/* eslint-disable import/prefer-default-export */

import styled, { css } from 'styled-components'
import { CheckboxGroup } from 'react-checkbox-group'

import { getColor, getVariable } from '@aller/shiny/src/utils'
// import SmallRoundedButton from '../../../shared-components/Typography/SmallRoundedButton'
import { SmallRoundedButton } from '@aller/shiny/src/atoms/RoundedButtons'

export const StyledDiv = styled.div`
	${props => {
		const horizontalBase = getVariable('horizontalBase')(props)
		const verticalBase = getVariable('verticalBase')(props)
		const largeWidth = getVariable('largeWidth')(props)
		const grayTint = getColor('grayTint')(props)

		return css`
			display: flex;
			flex: 0 0 auto;
			flex-direction: row;
			width: 100%;
			padding: 2.4rem;
			padding-top: 0;

			h1 {
				padding: ${verticalBase} 0 1rem;
				margin-bottom: calc(${verticalBase} / 2);
				border-bottom: 0.1rem solid ${grayTint};
			}

			@media (min-width: ${largeWidth}) {
				padding: calc(${horizontalBase} * 2);
				padding-top: 0;
			}
		`
	}};
`

export const StyledCheckboxGroup = styled(CheckboxGroup)`
	display: flex;
	flex: 0 0 100%;
	flex-wrap: wrap;

	div {
		flex: 1 1 30%;
	}
`

export const StyledSmallRoundedButton = styled(SmallRoundedButton)`
	${props => {
		const horizontalBase = getVariable('horizontalBase')(props)
		const verticalBase = getVariable('verticalBase')(props)

		return css`
			margin: calc(${verticalBase} / 2) calc(${horizontalBase} / 2) 0 0;
		`
	}};
`

export const StyledCheckbox = styled.div`
	${props => {
		const horizontalBase = getVariable('horizontalBase')(props)

		return css`
		margin: .2rem;
		padding: calc(${horizontalBase} / 4) 0;

		label {
			width: 100%;
			display: block;
			padding: 0;
			margin: 0;
		}

		[type='checkbox'] {
			vertical-align: baseline;
			width: ${horizontalBase};
			height: ${horizontalBase};
			margin-right: ${horizontalBase};
			`
	}};
`
