import propTypes from 'prop-types'
import styled from 'styled-components'

const FlexBox = styled.div`
	display: flex;
	position: relative;
	flex: 1 0 ${props => props.flexBasis};
	flex-wrap: wrap;
	background: ${props => props.background};
	flex-direction: ${props => props.direction};
`

FlexBox.propTypes = {
	background: propTypes.string,
	flexBasis: propTypes.string
}

FlexBox.defaultProps = {
	background: 'transparent',
	flexBasis: '100%'
}

export default FlexBox
