import React from 'react'
import axios from 'axios'
import styled from 'styled-components'
import { getVariable, getColor } from '@aller/shiny/src/utils'

const StyledWrapper = styled.div`
	background: linear-gradient(${getVariable('grayTint')}, transparent 0.1rem);
`

const SpacedWrapper = styled.div`
	margin: 0 ${getVariable('horizontalBase')} 0.5rem;
`

const TagLink = styled.a`
	margin-right: 1rem;
	margin-bottom: 1rem;
	background: #ececec;
	padding: 0.2rem 1rem 0.5rem;
	border-radius: 10rem;
	display: inline-block;
	color: #222;
	font-weight: 500;
`

const StyledHeading = styled.h3`
	flex: 0 0 auto;
	width: 100%;
	padding: 1.8rem 0 1.5rem 0;
	color: ${getColor('darkness', 'light')};
	font-size: 1.8rem;
	font-weight: 800;
`

class Tags extends React.Component {
	_isMounted = false

	constructor(props) {
		super(props)

		this.state = {
			tags: false
		}
	}

	componentDidMount() {
		this._isMounted = true
		axios
			.get('https://sol.no/app/harvester-webservice/get/tagsaggs', {
				params: {
					excludeTags: 'utenlandske',
					tagFields: 'tags',
					depth: 150,
					limit: 10
				},
				timeout: 5000
			})
			.then(response => {
				if (this._isMounted) {
					this.setState({
						tags: response.data
					})
				}
			})
	}

	componentWillUnmount(){
		this._isMounted = false;
	}

	render() {
		const { tags } = this.state
		if (!tags) {
			return null
		}

		return (
			<StyledWrapper>
				<SpacedWrapper>
					<StyledHeading>Akkurat nå skrives det mye om:</StyledHeading>
					{tags.map((tag, i) => {
						return (
							<TagLink
								href={`/stikkord/${encodeURIComponent(tag[0])}`}
								key={i}
								type="a"
								background="grayTintLightDark"
							>
								{tag[0]}
							</TagLink>
						)
					})}
				</SpacedWrapper>
			</StyledWrapper>
		)
	}
}

export default Tags
