/* eslint-disable import/prefer-default-export */

import styled from 'styled-components'
import { Button } from '@aller/shiny/src/atoms/Button'

export const PaginationButton = styled(Button)`
	color: ${props => (props.active ? '#333' : '')};
	background: ${props => (props.active ? '#ececec' : '#f1f1f1')};
	cursor: ${props => (props.active ? 'pointer' : 'auto')};
	font-weight: ${props => (props.active ? 'bold' : 'normal')};
	width: calc(50% - 1.4rem);
	height: 4.2rem;
	margin: 0 0.7rem;
	flex-grow: 1;
`

export const ButtonContainer = styled.div`
	clear: both;
	flex: 1 0 100%;
	z-index: 1;
	position: relative;
	align-items: center;
	margin-bottom: 0.7rem;
	justify-content: center;
`
