import React from 'react'
import propTypes from 'prop-types'
import { connect } from 'react-redux'
import { bindActionCreators } from 'redux'
import { LinkBarLink } from '@aller/shiny/src/atoms/LinkBarLink'

import logClick from '../services/log-click'
import { showSettings, hideSettings } from '../actions'

class SettingsButton extends React.Component {
	handleClick = event => {
		event.preventDefault()

		const {
			actions: { showSettings, hideSettings },
			displaySettings
		} = this.props

		logClick('newsstream_menu_settings')
		displaySettings ? hideSettings() : showSettings()
	}

	render() {
		const {
			displaySettings: { isActive }
		} = this.props
		return (
			<LinkBarLink
				linkText="Innstillinger"
				url="#settings"
				useUnderline={false}
				onClick={this.handleClick}
				isActive={isActive}
			/>
		)
	}
}

SettingsButton.propTypes = {
	actions: propTypes.shape({
		showSettings: propTypes.func.isRequired,
		hideSettings: propTypes.func.isRequired
	}).isRequired,
	displaySettings: propTypes.bool.isRequired
}

function mapStateToProps(state) {
	return {
		displaySettings: state.displaySettings
	}
}

function mapDispatchToProps(dispatch) {
	return {
		actions: bindActionCreators(
			{
				showSettings,
				hideSettings
			},
			dispatch
		)
	}
}

export default connect(
	mapStateToProps,
	mapDispatchToProps
)(SettingsButton)
