import React from 'react'
import propTypes from 'prop-types'
import { connect } from 'react-redux'
import { bindActionCreators } from 'redux'
import { Checkbox } from 'react-checkbox-group'
import { MediumHeading } from '@aller/shiny/src/atoms/Heading'

import logClick from '../services/log-click'
import { storeSettings, hideSettings, setActiveCategory, getArticles } from '../actions'

import {
	StyledDiv,
	StyledCheckboxGroup,
	StyledSmallRoundedButton,
	StyledCheckbox
} from '../styles/settings'

class Settings extends React.Component {
	constructor(props) {
		super(props)
		const { selectedCounties } = props
		this.state = {
			tmpSelected: selectedCounties
		}
	}

	onCheckboxClick = tmpSelected => {
		this.setState({ tmpSelected })
	}

	saveSettings = event => {
		event.preventDefault()

		const {
			actions: { storeSettings, hideSettings, setActiveCategory, getArticles },
			currentCategory,
			previousCategory
		} = this.props

		const { tmpSelected: selected } = this.state

		logClick('newsstream_settings_save')
		storeSettings(selected)
		if (currentCategory === 'lokale' && selected.length === 0) {
			setActiveCategory(previousCategory)
		}
		getArticles('lokale') // TODO: here we must test for what is changed when we add more settings than local-news
		hideSettings()
	}

	cancelClick = event => {
		event.preventDefault()

		const {
			actions: { hideSettings, setActiveCategory },
			selectedCounties,
			currentCategory,
			previousCategory
		} = this.props

		if (currentCategory === 'lokale' && selectedCounties.length === 0) {
			setActiveCategory(previousCategory)
		}

		hideSettings()
	}

	renderButtons = () => {
		return (
			<div>
				<StyledSmallRoundedButton
					background="grayTint"
					color="type"
					href="#nyhetsstrom"
					onClick={this.cancelClick}
				>
					Avbryt
				</StyledSmallRoundedButton>
				<StyledSmallRoundedButton
					background="grayTint"
					color="type"
					href="#nyhetsstrom"
					onClick={this.saveSettings}
				>
					Lagre
				</StyledSmallRoundedButton>
			</div>
		)
	}

	renderSettings = () => {
		const { counties } = this.props

		const { tmpSelected } = this.state

		// const checkboxes =

		return (
			<div>
				<MediumHeading>Velg regioner for lokale nyheter</MediumHeading>
				<StyledCheckboxGroup
					value={tmpSelected}
					// eslint-disable-next-line
					ref="localNewsSources" // TODO: fix eslint
					onChange={this.onCheckboxClick}
					checkboxDepth={3}
				>
					{counties.map((county, i) => {
						/* eslint-disable jsx-a11y/label-has-for */
						return (
							<StyledCheckbox key={county.name}>
								<label htmlFor={`county${i}`}>
									<Checkbox className={`county${i}`} id={`county${i}`} value={county.harvester} />
									{county.name}
								</label>
							</StyledCheckbox>
						)
					})}
				</StyledCheckboxGroup>
				{this.renderButtons()}
			</div>
		)
	}

	render() {
		return <StyledDiv>{this.renderSettings()}</StyledDiv>
	}
}

Settings.propTypes = {
	actions: propTypes.shape({
		storeSettings: propTypes.func.isRequired,
		hideSettings: propTypes.func.isRequired,
		setActiveCategory: propTypes.func.isRequired,
		getArticles: propTypes.func.isRequired
	}).isRequired,
	counties: propTypes.arrayOf(propTypes.object).isRequired,
	selectedCounties: propTypes.arrayOf(propTypes.string).isRequired,
	currentCategory: propTypes.string.isRequired,
	previousCategory: propTypes.string.isRequired
}

function mapStateToProps(state) {
	return {
		selectedCounties: state.settings.localNews.selectedCounties,
		counties: state.counties,
		currentCategory: state.currentCategory,
		previousCategory: state.previousCategory
	}
}

function mapDispatchToProps(dispatch) {
	return {
		actions: bindActionCreators(
			{
				storeSettings,
				hideSettings,
				setActiveCategory,
				getArticles
			},
			dispatch
		)
	}
}

export default connect(
	mapStateToProps,
	mapDispatchToProps
)(Settings)
