import React from 'react'
import propTypes from 'prop-types'

import { SmallLinkBarButton } from '@aller/shiny/src/atoms/LinkBarButton'
import { getColor } from '@aller/shiny/src/utils/get-color'

import logClick from '../services/log-click'

import NewsPaperLogo from '../styles/news-paper-logo'

export default class NewsPaperButton extends React.Component {
	handleClick = event => {
		event.stopPropagation()

		const { hostName, setActiveNewsPaperInCategory, currentCategory } = this.props

		logClick(`newsstream_submenu_${currentCategory}_${hostName}`)
		setActiveNewsPaperInCategory(hostName)
	}

	render() {
		const { hostName, isActive, isDesktop } = this.props

		const imageSize = isDesktop ? 80 : 80

		return (
			<SmallLinkBarButton
				isActive={isActive}
				activeBackgroundColor="grayTintLight"
				useUnderline={false}
				onClick={this.handleClick}
			>
				<NewsPaperLogo
					alt={hostName}
					title={hostName}
					src={`https://sol.no/s/img/w_${imageSize},c_fill/sitelogos/www.${hostName}.png`}
					onClick={this.handleClick}
				/>
			</SmallLinkBarButton>
		)
	}
}

NewsPaperButton.propTypes = {
	setActiveNewsPaperInCategory: propTypes.func.isRequired,
	hostName: propTypes.string.isRequired,
	isActive: propTypes.bool.isRequired,
	isDesktop: propTypes.bool.isRequired,
	currentCategory: propTypes.string.isRequired
}
