import React, { useEffect } from 'react'
import propTypes from 'prop-types'
import { connect } from 'react-redux'
import { bindActionCreators } from 'redux'
import { withTheme } from 'styled-components'
import { getColor } from '@aller/shiny/src/utils/'
import { useIsMobile } from '@aller/shared/hooks/useIsMobile'
import XavierContentAd from '@aller/shared/components/LoganAds/XavierContentAd'
import DoubleSideAds from '../../doubleSideAds'
import { fetchSettings, getArticles } from '../actions'
import MediumRectangle from '../../LoganAds/MediumRectangle'

import ArticleCard from './ArticleCard'
import ArticleList from './ArticleList'
import CategoryNavigationBar from './CategoryNavBar'
import Error from './Error'
import Header from './Header'
import Loader from './Loader'
import Tags from './Tags'
import NewsPaperButtons from './NewsPaperButtons'
import Pagination from './Pagination'
import Section from '../styles/NewsStreamSection'
import Settings from './Settings'

const Logan = props => {
	useEffect(() => {
		const {
			actions: { getArticles, fetchSettings },
			currentCategory,
		} = props
		fetchSettings()
		getArticles(currentCategory)
	}, []) // eslint-disable-line

	const { displaySettings } = props
	const background = getColor('white')(props)

	if (useIsMobile()) {
		return (
			<Section style={{ marginLeft: '-1.5rem', marginRight: '-1.5rem' }}>
				<Header />
				<div style={{ background }}>
					<CategoryNavigationBar />
					<NewsPaperButtons />
					<div>
						{!displaySettings && <ArticleCard />}
						{displaySettings ? (
							<Settings />
						) : (
							<>
								<ArticleList />
								<Pagination />
							</>
						)}
					</div>

					<Error />
					<Loader />
				</div>
				<Tags />
			</Section>
		)
	}

	return (
		<div style={{ display: 'flex', width: '100%' }}>
			<Section>
				<Header />
				<div style={{ background }}>
					<CategoryNavigationBar />
					<NewsPaperButtons />
					<div>
						{!displaySettings && <ArticleCard />}
						{displaySettings ? (
							<Settings />
						) : (
							<>
								<ArticleList />
								<Pagination />
							</>
						)}
					</div>

					<Error />
					<Loader />
				</div>
				<Tags />
			</Section>
			<DoubleSideAds>
				<XavierContentAd fontSizeOverride={2.2} column={{ md: 12 }} pos={props.contentPos} />
				<MediumRectangle pos={props.mediumRectanglePos} />
			</DoubleSideAds>
		</div>
	)
}

Logan.propTypes = {
	displaySettings: propTypes.bool.isRequired,
	currentCategory: propTypes.string,
	elementCounter: propTypes.shape({}),
	actions: propTypes.shape({
		fetchSettings: propTypes.func.isRequired,
	}).isRequired,
}

Logan.defaultProps = {
	currentCategory: {},
	elementCounter: {},
}

function mapStateToProps(state) {
	return {
		displaySettings: state.displaySettings,
		currentCategory: state.currentCategory,
	}
}

function mapDispatchToProps(dispatch) {
	return {
		actions: bindActionCreators(
			{
				fetchSettings,
				getArticles,
			},
			dispatch,
		),
	}
}

export default withTheme(
	connect(
		mapStateToProps,
		mapDispatchToProps,
	)(Logan),
)
