import React from 'react'
import propTypes from 'prop-types'
import { connect } from 'react-redux'
import styled from 'styled-components'

import NoonLoader from './NoonLoader/NoonLoader'

export const FlexRow = styled.div`
	flex: 1 0 100%;
`

function Loader({ isLoading }) {
	if (!isLoading) {
		// return null
	}

	return (
		<FlexRow>
			<NoonLoader />
		</FlexRow>
	)
}

Loader.propTypes = {
	isLoading: propTypes.bool.isRequired
}

function mapStateToProps(state) {
	return {
		isLoading: state.isLoading
	}
}

export default connect(mapStateToProps)(Loader)
