/* eslint-disable jsx-a11y/mouse-events-have-key-events */

import React from 'react'
import propTypes from 'prop-types'

import makeLinkpulseClassName from '../../../utils/make-linkpulse-class-name'

import { Link, Time, Content, Source } from './styles/article'

function formatTime(dateTime) {
	const d = new Date(dateTime)
	const h = (d.getHours() < 10 ? '0' : '') + d.getHours()
	const m = (d.getMinutes() < 10 ? '0' : '') + d.getMinutes()
	return `${h}:${m}`
}

const ListPlugWithTime = ({
	position,
	handleHover,
	index,
	isLast,
	host,
	rel,
	target,
	title,
	updateTime,
	url
}) => {
	const timeNow = formatTime(updateTime)

	return (
		<article onMouseOver={() => handleHover(index)}>
			<Link
				href={url}
				className={makeLinkpulseClassName(position)}
				target={target}
				rel={rel}
				isLast={isLast}
			>
				<Time>{timeNow}</Time>
				<Content>
					{title}
					<Source>{host}</Source>
				</Content>
			</Link>
		</article>
	)
}

ListPlugWithTime.defaultProps = {
	isLast: false,
	handleHover: () => {},
	target: '_self',
	position: 0
}

ListPlugWithTime.propTypes = {
	position: propTypes.oneOfType([propTypes.string, propTypes.number]),
	handleHover: propTypes.func,
	host: propTypes.string.isRequired,
	index: propTypes.number.isRequired,
	isLast: propTypes.bool,
	rel: propTypes.string.isRequired,
	target: propTypes.oneOf(['_blank', '_self', '_top']),
	title: propTypes.string.isRequired,
	updateTime: propTypes.string.isRequired,
	url: propTypes.string.isRequired
}

export default ListPlugWithTime
