import React from 'react'
import propTypes from 'prop-types'
import { connect } from 'react-redux'
import { bindActionCreators } from 'redux'
import { withTheme } from 'styled-components'
import { getColor } from '@aller/shiny/src/utils/'
import DoubleSideAds from '../../doubleSideAds'
import XavierContentAd from '../../XavierContentAd'
import { XavierContext } from '../../../store/xavier'
import { fetchSettings, getArticles } from '../actions'

import ArticleCard from './ArticleCard'
import ArticleList from './ArticleList'
import CategoryNavigationBar from './CategoryNavBar'
import Error from './Error'
import Header from './Header'
import Loader from './Loader'
import Tags from './Tags'
import NewsPaperButtons from './NewsPaperButtons'
import Pagination from './Pagination'
import Section from '../styles/NewsStreamSection'
import Settings from './Settings'
import AdPrebid from '../../Ad/prebid'

class Index extends React.Component {
	componentWillMount() {
		const {
			actions: { fetchSettings },
		} = this.props
		fetchSettings()
	}

	componentDidMount() {
		const {
			actions: { getArticles },
			currentCategory,
		} = this.props
		getArticles(currentCategory)
	}

	render() {
		const { displaySettings, device, elementCounter } = this.props
		const background = getColor('white')(this.props)

		if (device.mobile) {
			return (
				<Section>
					<Header />
					<div style={{ background }}>
						<CategoryNavigationBar />
						<NewsPaperButtons />
						<div>
							{!displaySettings && <ArticleCard />}
							{displaySettings ? (
								<Settings />
							) : (
								<>
									<ArticleList />
									<Pagination />
								</>
							)}
						</div>

						<Error />
						<Loader />
					</div>
					<Tags />
				</Section>
			)
		}

		return (
			<div style={{ display: 'flex' }}>
				<Section>
					<Header />
					<div style={{ background }}>
						<CategoryNavigationBar />
						<NewsPaperButtons />
						<div>
							{!displaySettings && <ArticleCard />}
							{displaySettings ? (
								<Settings />
							) : (
								<>
									<ArticleList />
									<Pagination />
								</>
							)}
						</div>

						<Error />
						<Loader />
					</div>
					<Tags />
				</Section>
				<DoubleSideAds>
					<XavierContext.Consumer>
						{context => (
							<XavierContentAd
								context={context}
								column={{ xs: 12, md: 4 }}
								elementCounter={elementCounter}
							/>
						)}
					</XavierContext.Consumer>
					<AdPrebid id={`ad-medium-rectangle${elementCounter.displayAd}`} {...this.props} />
				</DoubleSideAds>
			</div>
		)
	}
}

Index.propTypes = {
	displaySettings: propTypes.bool.isRequired,
	currentCategory: propTypes.string,
	elementCounter: propTypes.shape({}),
	device: propTypes.shape({}),
	actions: propTypes.shape({
		fetchSettings: propTypes.func.isRequired,
	}).isRequired,
}

Index.defaultProps = {
	device: {},
	currentCategory: {},
	elementCounter: {},
}

function mapStateToProps(state) {
	return {
		displaySettings: state.displaySettings,
		currentCategory: state.currentCategory,
	}
}

function mapDispatchToProps(dispatch) {
	return {
		actions: bindActionCreators(
			{
				fetchSettings,
				getArticles,
			},
			dispatch,
		),
	}
}

export default withTheme(
	connect(
		mapStateToProps,
		mapDispatchToProps,
	)(Index),
)
