import React from 'react'
import propTypes from 'prop-types'
import { connect } from 'react-redux'

import { StyledError } from '../styles/error'

function Error({ error }) {
	if (!error) {
		return null
	}

	return <StyledError>{error}</StyledError>
}

Error.defaultProps = {
	error: ''
}

Error.propTypes = {
	error: propTypes.string
}

function mapStateToProps(state) {
	return {
		error: state.error
	}
}

export default connect(mapStateToProps)(Error)
