import React from 'react'

import { XavierMostReadContext } from '@aller/shared/providers/XavierProvider' // eslint-disable-line import/no-extraneous-dependencies
import getHostname from '../../utils/get-hostname'
import Container from './Container'
import CustomCol from './CustomCol'
import Heading from './Heading'
import List from './List'
import ListElement from './ListElement'
import Number from './Number'
import Source from './Source'
import Content from './Content'

const MostRead = () => {
	return (
		<CustomCol style={{ maxHeight: '450px' }} md={4}>
			<XavierMostReadContext.Consumer>
				{context => {
					return (
						<Container>
							<Heading>Mest lest</Heading>
							<List>
								{context &&
									context.length > 0 &&
									context.slice(0, 5).map((article, i) => {
										return (
											<ListElement
												key={`mostread_${i}`}
												target="_blank"
												className="lp_most_read"
												href={article.url}
											>
												<Number style={{ top: '-2.7rem' }}>{i + 1}</Number>
												<Content>
													{article.title.length < 77
														? article.title
														: `${article.title.slice(0, 77)}..`}
												</Content>
												<Source>{getHostname(article.url)}</Source>
											</ListElement>
										)
									})}
							</List>
						</Container>
					)
				}}
			</XavierMostReadContext.Consumer>
		</CustomCol>
	)
}

export default MostRead
