import styled from 'styled-components'

const ListElement = styled.a`
	padding: 1.2rem 1.5rem;
	font-size: 1.6rem;
	width: 100%;
	padding-right: 40px;
	position: relative;
	color: #514f4f;
	font-weight: 600;
	overflow: hidden;
	height: 7rem;

	&:after,
	&:first-child:before {
		content: '';
		display: block;
		height: 0.1rem;
		background: #f1f1f1;
		width: calc(100% - 1rem);
		margin: 0 0.5rem;
		position: absolute;
		bottom: 0;
		left: 0;
	}

	&:first-child:before {
		top: 0;
	}

	&:last-child:after {
		display: none;
	}
`

export default ListElement
