import React from 'react'
import propTypes from 'prop-types'

// The Meta tag should go in the Head section
const Meta = ({ name, property, content }) => <meta {...{ name, property, content }} />

Meta.propTypes = {
	name: propTypes.string,
	property: propTypes.string,
	content: propTypes.string,
}
Meta.defaultProps = {
	name: null,
	property: null,
	content: null,
}

export default Meta
