import styled from 'styled-components'
import React from 'react'
import propTypes from 'prop-types'
import { getVariable } from '@aller/shiny/src/utils/get-variable'

const MainStyle = styled.main`
	position: relative;
	background-color: ${prop => (prop.theme.name === 'SOL' ? '#f9f8fa;' : 'transparent')};

	&.video-main {
		@media (min-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
			padding-bottom: ${getVariable('verticalBase')};
		}
	}
`
const Main = ({ children, mainClass }) => {
	return <MainStyle className={mainClass}>{children}</MainStyle>
}

Main.propTypes = {
	children: propTypes.oneOfType([propTypes.arrayOf(propTypes.node), propTypes.node]).isRequired,
	mainClass: propTypes.string.isRequired,
}

export default Main
