import React from 'react'

import GridRow from '@aller/shared/components/GridRow'
import { useArticles } from '@aller/shared/store/ArticleStore'

import SolPlug from '../SolPlug/Plug/SolPlug'
import { StandardizedArticlePreviewFormat } from '../../utils/standardize-articles/types'

const TwelveCard = () => {
	let articles = useArticles(1) as StandardizedArticlePreviewFormat[]
	if (articles.length < 1) return null

	return (
		<GridRow>
			<SolPlug
				{...articles[0]}
				column={{
					xs: 12,
					md: Math.floor(Math.random() * 11) + 1,
				}}
				linkpulsePersonalizedClass
				colorTheme={articles[0].backgroundColor}
			/>
		</GridRow>
	)
}
;(TwelveCard as any).whyDidYouRender = true

export default TwelveCard
