import React from 'react'

import GridRow from '../GridRow'
import LoganPlug from '../LoganPlug'

import { Article } from '../../graphql/types'

interface Props {
	articles: Article[]
	type?: 'tall' | 'square' | 'taller'
	loading?: 'eager' | 'lazy'
}

const columnSize = {
	xs: 12,
	md: 6
}

const SixSix: React.FC<Props> = ({ articles, type, loading = 'lazy' }) => {
	let ratio = 0.5

	if (type === 'taller') {
		ratio = 1.3
	}

	if (type === 'tall') {
		ratio = 0.75
	}

	if (type === 'square') {
		ratio = 1
	}
	return (
		<GridRow>
			{articles.map(({ cleanImage, secondaryTitle, sectionTag, ...rest }, i) => {
				if (i > 2) return null
				return (
					<LoganPlug
						baseImageUrl={cleanImage}
						key={rest.url}
						loading={loading}
						ratio={ratio}
						category={secondaryTitle || sectionTag}
						column={columnSize}
						{...rest}
					/>
				)
			})}
		</GridRow>
	)
}
;(SixSix as any).whyDidYouRender = true

export default SixSix
