import React from 'react'
import { Row } from '@aller/shiny/src/atoms/Row'
import { Col } from '@aller/shiny/src/atoms/Col'

import GridRow from '../GridRow'
import LoganPlug from '../LoganPlug'
import NetboardAd from '../LoganAds/Netboard'

import { Article } from '../../graphql/types'

interface Props {
	articles: Article[]
	isVideo?: boolean
	loading?: 'eager' | 'lazy'
}

const columnSize = {
	xs: 12,
	md: 12
}

const Netboard: React.FC<Props> = ({ articles, isVideo = false, loading = 'lazy' }) => {
	const {
		cleanImage,
		secondaryTitle,
		sectionTag,
		...rest
	} = articles[0]

	return (
		<GridRow>
			<Col xs={8}>
				<NetboardAd pos={1} />
			</Col>
			<Col xs={4}>
				<Row>
					<LoganPlug
						baseImageUrl={cleanImage}
						ratio={0.5}
						category={isVideo ? 'video' : secondaryTitle || sectionTag}
						loading={loading}
						column={columnSize}
						{...rest}
					/>
				</Row>
			</Col>
		</GridRow>
	)
}
;(Netboard as any).whyDidYouRender = true

export default Netboard
