import React from 'react'

import GridRow from '@aller/shared/components/GridRow'
import { useArticles } from '@aller/shared/store/ArticleStore'

import { getImageRatioByTitle } from '../../utils/get-image-ratio-by-title'
import SolPlug from '../SolPlug/Plug/SolPlug'
import { StandardizedArticlePreviewFormat } from '../../utils/standardize-articles/types'

interface Props {
	type?: 'grow'
}

const FourFourFourCard: React.FC<Props> = ({ type }) => {
	const articles: any = useArticles(3)

	let adjustedArticles = articles.map(
		(article: StandardizedArticlePreviewFormat): StandardizedArticlePreviewFormat => {
			article.imageRatio = 0.5
			return article
		},
	)

	if (type === 'grow') {
		adjustedArticles = getImageRatioByTitle(adjustedArticles as any, [4, 4, 4])
	}

	if (articles.length < 3) return null

	return (
		<GridRow>
			<SolPlug
				{...adjustedArticles[0]}
				column={{
					xs: 12,
					md: 4,
				}}
				linkpulsePersonalizedClass
				colorTheme={adjustedArticles[0].backgroundColor}
			/>
			<SolPlug
				{...adjustedArticles[1]}
				column={{
					xs: 12,
					md: 4,
				}}
				linkpulsePersonalizedClass
				colorTheme={adjustedArticles[1].backgroundColor}
			/>
			<SolPlug
				{...adjustedArticles[2]}
				column={{
					xs: 12,
					md: 4,
				}}
				linkpulsePersonalizedClass
				colorTheme={adjustedArticles[2].backgroundColor}
			/>
		</GridRow>
	)
}
;(FourFourFourCard as any).whyDidYouRender = true

export default FourFourFourCard
