import React from 'react'

import GridRow from '../GridRow'
import LoganPlug from '../LoganPlug'

import { Article } from '../../graphql/types'

interface Props {
	articles: Article[]
	type?: 'tall' | 'square' | 'taller'
	loading?: 'eager' | 'lazy'
}

const columnSize = {
	xs: 12,
	md: 4
}

const FourFourFour: React.FC<Props> = ({ articles, type, loading = 'lazy' }) => {
	let ratio = 0.5

	if (type === 'tall') {
		ratio = 0.75
	}

	if (type === 'taller') {
		ratio = 1.3
	}

	if (type === 'square') {
		ratio = 1
	}

	return (
		<GridRow>
			{articles.map(({ cleanImage, secondaryTitle, sectionTag, ...rest }, i) => {
				if (i > 3) return null
				return (
					<LoganPlug
						type="medium"
						key={rest.url}
						baseImageUrl={cleanImage}
						loading={loading}
						ratio={ratio}
						category={secondaryTitle || sectionTag}
						column={columnSize}
						{...rest}
					/>
				)
			})}
		</GridRow>
	)
}
;(FourFourFour as any).whyDidYouRender = true

export default FourFourFour
