import React from 'react'

import GridRow from '../GridRow'
import LoganPlug from '../LoganPlug'
import ContentSwitch from '../LoganAds/ContentSwitch'

import { Video, Article, ContentMarketing } from '../../graphql/types'

interface Props {
	adPos: number
	articles: Article[]
	videos?: Video[]
	contentMarketing: ContentMarketing[]
	loading?: 'eager' | 'lazy'
	type?: 'tall' | 'square' | 'taller'
}

const columnSize = {
	xs: 12,
	md: 4
}

const FourFourAd: React.FC<Props> = ({
	adPos,
	articles,
	videos = [],
	loading = 'lazy',
	type,
	contentMarketing
}) => {
	let ratio = 0.5

	if (type === 'tall') {
		ratio = 0.75
	}

	if (type === 'taller') {
		ratio = 1.3
	}

	if (type === 'square') {
		ratio = 1
	}

	return (
		<GridRow>
			{videos.length > 0 && (
				<LoganPlug
					baseImageUrl={videos[0].cleanImage}
					loading={loading}
					ratio={ratio}
					category="video"
					column={columnSize}
					preset={videos[0].preset}
					title={videos[0].title}
					url={videos[0].url}
				/>
			)}

			{articles.map(({ cleanImage, secondaryTitle, sectionTag, ...rest }, i) => {
				if (i > 2) return null
				return (
					<LoganPlug
						baseImageUrl={cleanImage}
						key={rest.url}
						loading={loading}
						ratio={ratio}
						category={secondaryTitle || sectionTag}
						column={columnSize}
						{...rest}
					/>
				)
			})}
			<ContentSwitch
				pos={adPos}
				{...contentMarketing[0]}
				column={{ xs: 12, md: 4 }}
				ratio={ratio}
			/>
		</GridRow>
	)
}
;(FourFourAd as any).whyDidYouRender = true

export default FourFourAd
