import React from 'react'
import ArticleStoreProvider from '../../store/ArticleStore'
import AdProvider from '../LoganAds/Provider'
import UserProvider from '../../providers/User'
import IsMobileProvder from '../../hooks/useIsMobile'
import IsMetarefreshProvider from '../../hooks/useIsMetarefresh'

interface Props {
	isMobile: boolean
	isMetarefresh: boolean
}

const LoganProviders: React.FC<Props> = ({ children, isMobile, isMetarefresh }) => (
	<ArticleStoreProvider>
		<IsMobileProvder initialState={isMobile}>
			<AdProvider>
				<IsMetarefreshProvider initialState={isMetarefresh}>
					<UserProvider>{children}</UserProvider>
				</IsMetarefreshProvider>
			</AdProvider>
		</IsMobileProvder>
	</ArticleStoreProvider>
)

export default LoganProviders
