import { useEffect } from 'react'

const Polyfills = () => {
	useEffect(() => {
		async function loadPolyfills() {
			if ('HTMLPictureElement' in window) {
				// Picture tag supported
			} else {
				const picturefill = await import('picturefill')
				await import('picturefill/dist/plugins/mutation/pf.mutation.min')
				picturefill.default({})
			}

			if ('IntersectionObserver' in window) {
				// Browser supports intersection observer
			} else {
				await import('intersection-observer')
			}
		}

		loadPolyfills()
	}, [])
	return null
}

export default Polyfills
