import React from 'react'
import { kkRender } from '../../utils/test-utils'
import LoganPlug from './index'

describe('LoganPlug', () => {
	it('renders without error', async () => {
		Object.defineProperty(document, 'lazyLoadInstance', {
			value: {
				update: () => ({})
			}
		})
		const { getByTestId } = kkRender(
			<LoganPlug
				url="http://www.dagbladet.no"
				title="This is an article!"
				baseImageUrl="https://dbstatic.no/"
			/>
		)

		const plug = getByTestId('logan-plug')
		const title = plug.querySelector('h1') || { innerHTML: '' }
		expect(title.innerHTML).toBe('This is an article!')
		const anchor = plug.querySelector('a')
		expect(anchor).toBeTruthy()
		const href = (anchor && anchor.getAttribute('href')) || null
		expect(href).toBe('http://www.dagbladet.no')
	})
})
