import React, { useEffect } from 'react'
import dynamic from 'next/dynamic'
import Router from 'next/router'
import styled from 'styled-components'

import { ShinyThemeProvider } from '@aller/shared/components/LoganThemeProvider'

const AdsModal = dynamic(() => import('../LoganAds/Modal'))
const PrivacyPopup = dynamic(() => import('../PrivacyPopup'))
const LoganProviders = dynamic(() => import('../LoganProviders'))
const BlinkLabrador = dynamic(() => import('../BlinkLabrador'))
const Polyfills = dynamic(() => import('../LoganPolyfills'))
const BrowserWarning = dynamic(() => import('../BrowserWarning'))

if (process.env.NODE_ENV !== 'production') {
	const whyDidYouRender = require('@welldone-software/why-did-you-render') // eslint-disable-line
	whyDidYouRender(React)
}

declare global {
	interface Window {
		pageInit: any
		trackPageload: any
		trackPerformance: any
		trackAdInscreen0: any
		trackAdInscreen: any
		blinkLabrador: any
		trackArticleImpressions: any
	}
}

const Main = styled.main`
	display: block;
	position: relative;
	background-color: ${(props: any) => (props.theme.name === 'SOL' ? '#f9f8fa;' : 'transparent')};
	font-family: ${(props: any) => props.theme.variables.mainFont};
`

const Layout: React.FC<{
	theme: any
	header: React.ReactElement
	footer: React.ReactElement
	isMobile?: boolean
	isMetarefresh?: boolean
}> = ({
	theme,
	children,
	header = null,
	footer = null,
	isMobile = false,
	isMetarefresh = false
}) => {
	useEffect(() => {
		const handleRouteChangeComplete = () => {
			if (
				typeof window !== 'undefined' &&
				typeof window.pageInit !== 'undefined' &&
				typeof window.trackPageload !== 'undefined'
			) {
				window.pageInit()
				window.trackPageload()
				window.trackPerformance()
			}
		}

		Router.events.on('routeChangeComplete', () => handleRouteChangeComplete)

		return () => {
			Router.events.off('routeChangeComplete', () => handleRouteChangeComplete)
		}
	}, [])
	return (
		<ShinyThemeProvider theme={theme}>
			<LoganProviders isMetarefresh={isMetarefresh} isMobile={isMobile}>
				<BrowserWarning />
				{header}
				<AdsModal />
				<BlinkLabrador />
				<Polyfills />
				<Main className="lp_main">{children}</Main>
				<PrivacyPopup />
				{footer}
			</LoganProviders>
		</ShinyThemeProvider>
	)
}
;(Layout as any).whyDidYouRender = true

export default Layout
