const adUnitPrefix = {
	'default': 'dagbladet.no',
	'www.kk.no': 'kk_ny',
	'www.dinside.no': 'dinside',
	'www.seher.no': 'seher',
	'sol.no': 'sol',
}

const frontAdUnit = {
	'default': 'forside',
	'www.kk.no': 'feed',
}

export function getSite() {
	if (process.browser) {
		const hostname = window.location.hostname.replace('stage.', '')
		return hostname
	}

	return null
}

export function getPath() {
	if (process.browser) {
		return window.location.pathname
	}

	return null
}

export function getSlotNameForPath(site, path, isMetaRefresh) {
	const prefix = adUnitPrefix[site] || adUnitPrefix.default
	const adUnit = frontAdUnit[site] || frontAdUnit.default

	if (site === 'sol.no' && !isMetaRefresh) {
		return `${prefix}/${adUnit}/premium`
	}

	return `${prefix}/${adUnit}`
}

const dimensions = {
	'default': { banner: { sizes: [[320, 250], [300, 250]] } },
	'ad-topbanner': { banner: { sizes: [[980, 300], [970, 250]] } },
	'ad-desktopbanner': { banner: { sizes: [[980, 300], [970, 250]] } },
	'ad-medium-rectangle': { banner: { sizes: [[320, 250], [300, 250]] } },
	'ad-medium-rectangleB': { banner: { sizes: [[320, 250], [300, 250]] } },
	'ad-medium-rectangle-perz': { banner: { sizes: [[320, 250], [300, 250]] } },
	'ad-netboard': { banner: { sizes: [[580, 400]] } },
	'ad-netboardB': { banner: { sizes: [[580, 400]] } },
	'ad-netboard-perz': { banner: { sizes: [[580, 400]] } },
	'ad-sticky-right-top': { banner: { sizes: [[120, 600], [160, 600]] } },
	'ad-sticky-right': { banner: { sizes: [[300, 600], [180, 500], [160, 600], [120, 600]] } },
	'ad-fullscreen': { banner: { sizes: [[1, 1], [1, 2]] } },
	'ad-smartbanner': { banner: { sizes: [[980, 600]] } },
	'ad-smartbanner-perz': { banner: { sizes: [[980, 600], [980, 300]] } },
	'ad-banner': { banner: { sizes: [[320, 250], [300, 250]] } },
	'ad-banner-perz': { banner: { sizes: [[320, 250], [300, 250]] } },
}

const config = {
	'default': {
		adform: {
			'ad-topbanner': { mid: 105053 },
			'ad-desktopbanner': { mid: 105053 },
			'ad-medium-rectangle': { mid: 92962 },
			'ad-medium-rectangleB': { mid: 92962 },
			'ad-medium-rectangle-perz': { mid: 92962 },
			'ad-netboard': { mid: 91970 },
			'ad-netboardB': { mid: 91970 },
			'ad-netboard-perz': { mid: 91970 },
			'ad-sticky-right-top': { mid: 113921 },
			'ad-sticky-right': { mid: 113921 },
			'ad-fullscreen': { mid: 214504 },
			'ad-smartbanner': { mid: 645524 },
			'ad-smartbanner-perz': { mid: 645524 },
			'ad-banner': { mid: 91971 },
			'ad-banner-perz': { mid: 91971 },
		},
		rubicon: {
			'ad-topbanner': { accountId: 15770, siteId: 115612, zoneId: 1058548 },
			'ad-desktopbanner': { accountId: 15770, siteId: 115612, zoneId: 1058548 },
			'ad-medium-rectangle': { accountId: 15770, siteId: 115612, zoneId: 1058564 },
			'ad-medium-rectangleB': { accountId: 15770, siteId: 115612, zoneId: 1058564 },
			'ad-medium-rectangle-perz': { accountId: 15770, siteId: 115612, zoneId: 1058564 },
			'ad-netboard': { accountId: 15770, siteId: 115612, zoneId: 1058558 },
			'ad-netboardB': { accountId: 15770, siteId: 115612, zoneId: 1058558 },
			'ad-netboard-perz': { accountId: 15770, siteId: 115612, zoneId: 1058558 },
			'ad-sticky-right-top': { accountId: 15770, siteId: 115612, zoneId: 1058554 },
			'ad-sticky-right': { accountId: 15770, siteId: 115612, zoneId: 1058554 },
			'ad-smartbanner': { accountId: 15770, siteId: 115612, zoneId: 1058592 },
			'ad-smartbanner-perz': { accountId: 15770, siteId: 115612, zoneId: 1058592 },
			'ad-banner': { accountId: 15770, siteId: 115612, zoneId: 1058566 },
			'ad-banner-perz': { accountId: 15770, siteId: 115612, zoneId: 1058566 },
		},
		appnexus: {
			'ad-desktopbanner': { invCode: 'dagbladet-wde_ros_topbanner', member: 9742 },
			'ad-topbanner': { invCode: 'dagbladet-wde_ros_topbanner', member: 9742 },
			'ad-medium-rectangle': { invCode: 'dagbladet-wde_ros_rectangle', member: 9742 },
			'ad-medium-rectangleB': { invCode: 'dagbladet-wde_ros_rectangle', member: 9742 },
			'ad-medium-rectangle-perz': { invCode: 'dagbladet-wde_ros_rectangle', member: 9742 },
			'ad-netboard': { invCode: 'dagbladet-wde_ros_netboard', member: 9742 },
			'ad-netboardB': { invCode: 'dagbladet-wde_ros_netboard', member: 9742 },
			'ad-netboard-perz': { invCode: 'dagbladet-wde_ros_netboard', member: 9742 },
			'ad-sticky-right-top': { invCode: 'dagbladet-wde_ros_skyscraper', member: 9742 },
			'ad-sticky-right': { invCode: 'dagbladet-wde_ros_skyscraper', member: 9742 },
			'ad-smartbanner': { invCode: 'dagbladet-wde_ros_smartbanner', member: 9742 },
			'ad-smartbanner-perz': { invCode: 'dagbladet-wde_ros_smartbanner', member: 9742 },
			'ad-banner': { invCode: 'dagbladet-wph_ros_rectangle', member: 9742 },
			'ad-banner-perz': { invCode: 'dagbladet-wph_ros_rectangle', member: 9742 },
		},
	},
	'www.kk.no': {
		adform: {
			'ad-topbanner': { mid: 144616 },
			'ad-desktopbanner': { mid: 144616 },
			'ad-medium-rectangle': { mid: 144667 },
			'ad-medium-rectangleB': { mid: 144667 },
			'ad-medium-rectangle-perz': { mid: 144667 },
			'ad-netboard': { mid: 144627 },
			'ad-netboardB': { mid: 144627 },
			'ad-netboard-perz': { mid: 144627 },
			'ad-sticky-right-top': { mid: 595386 },
			'ad-sticky-right': { mid: 595386 },
			'ad-fullscreen': { mid: 598125 },
			'ad-smartbanner': { mid: 577188 },
			'ad-smartbanner-perz': { mid: 577188 },
			'ad-banner': { mid: 144698 },
			'ad-banner-perz': { mid: 144698 },
		},
		rubicon: {
			'ad-topbanner': { accountId: 15770, siteId: 189702, zoneId: 1058494 },
			'ad-desktopbanner': { accountId: 15770, siteId: 189702, zoneId: 1058498 },
			'ad-medium-rectangle': { accountId: 15770, siteId: 189702, zoneId: 1058504 },
			'ad-medium-rectangleB': { accountId: 15770, siteId: 189702, zoneId: 1058504 },
			'ad-medium-rectangle-perz': { accountId: 15770, siteId: 189702, zoneId: 1058504 },
			'ad-netboard': { accountId: 15770, siteId: 189702, zoneId: 1058512 },
			'ad-netboardB': { accountId: 15770, siteId: 189702, zoneId: 1058512 },
			'ad-netboard-perz': { accountId: 15770, siteId: 189702, zoneId: 1058512 },
			'ad-sticky-right-top': { accountId: 15770, siteId: 189702, zoneId: 1058502 },
			'ad-sticky-right': { accountId: 15770, siteId: 189702, zoneId: 1058502 },
			'ad-smartbanner': { accountId: 15770, siteId: 189702, zoneId: 929202 },
			'ad-smartbanner-perz': { accountId: 15770, siteId: 189702, zoneId: 929202 },
			'ad-banner': { accountId: 15770, siteId: 189702, zoneId: 1058506 },
			'ad-banner-perz': { accountId: 15770, siteId: 189702, zoneId: 1058506 },
		},
		appnexus: {
			'ad-desktopbanner': { invCode: 'kk-wde_ros_desktopbanner', member: 9742 },
			'ad-topbanner': { invCode: 'kk-wde_ros_topbanner', member: 9742 },
			'ad-medium-rectangle': { invCode: 'kk-wde_ros_rectangle', member: 9742 },
			'ad-medium-rectangleB': { invCode: 'kk-wde_ros_rectangle', member: 9742 },
			'ad-medium-rectangle-perz': { invCode: 'kk-wde_ros_rectangle', member: 9742 },
			'ad-netboard': { invCode: 'kk-wde_ros_netboard', member: 9742 },
			'ad-netboardB': { invCode: 'kk-wde_ros_netboard', member: 9742 },
			'ad-netboard-perz': { invCode: 'kk-wde_ros_netboard', member: 9742 },
			'ad-sticky-right-top': { invCode: 'kk-wde_ros_skyscraper', member: 9742 },
			'ad-sticky-right': { invCode: 'kk-wde_ros_skyscraper', member: 9742 },
			'ad-smartbanner': { invCode: 'kk-wde_ros_smartbanner', member: 9742 },
			'ad-smartbanner-perz': { invCode: 'kk-wde_ros_smartbanner', member: 9742 },
			'ad-banner': { invCode: 'kk-wph_ros_rectangle', member: 9742 },
			'ad-banner-perz': { invCode: 'kk-wph_ros_rectangle', member: 9742 },
		},
	},
	'sol.no': {
		adform: {
			'ad-topbanner': { mid: 301680 },
			'ad-desktopbanner': { mid: 301680 },
			'ad-medium-rectangle': { mid: 301678 },
			'ad-medium-rectangleB': { mid: 301678 },
			'ad-medium-rectangle-perz': { mid: 301678 },
			'ad-netboard': { mid: 537611 },
			'ad-netboardB': { mid: 537611 },
			'ad-netboard-perz': { mid: 537611 },
			'ad-sticky-right-top': { mid: 301679 },
			'ad-sticky-right': { mid: 301679 },
			'ad-fullscreen': { mid: 548314 },
			'ad-smartbanner': { mid: 530568 },
			'ad-smartbanner-perz': { mid: 530568 },
			'ad-banner': { mid: 301681 },
			'ad-banner-perz': { mid: 301681 },
		},
		rubicon: {
			'ad-topbanner': { accountId: 15770, siteId: 143858, zoneId: 1058440 },
			'ad-desktopbanner': { accountId: 15770, siteId: 143858, zoneId: 1058442 },
			'ad-medium-rectangle': { accountId: 15770, siteId: 143858, zoneId: 1058470 },
			'ad-medium-rectangleB': { accountId: 15770, siteId: 143858, zoneId: 1058470 },
			'ad-medium-rectangle-perz': { accountId: 15770, siteId: 143858, zoneId: 1058470 },
			'ad-netboard': { accountId: 15770, siteId: 143858, zoneId: 1058466 },
			'ad-netboardB': { accountId: 15770, siteId: 143858, zoneId: 1058466 },
			'ad-netboard-perz': { accountId: 15770, siteId: 143858, zoneId: 1058466 },
			'ad-sticky-right-top': { accountId: 15770, siteId: 143858, zoneId: 1058464 },
			'ad-sticky-right': { accountId: 15770, siteId: 143858, zoneId: 1058464 },
			'ad-smartbanner': { accountId: 15770, siteId: 143858, zoneId: 1058474 },
			'ad-smartbanner-perz': { accountId: 15770, siteId: 143858, zoneId: 1058474 },
			'ad-banner': { accountId: 15770, siteId: 143858, zoneId: 1058470 },
			'ad-banner-perz': { accountId: 15770, siteId: 143858, zoneId: 1058470 },
		},
		appnexus: {
			'ad-desktopbanner': { invCode: 'sol-wde_ros_desktopbanner', member: 9742 },
			'ad-topbanner': { invCode: 'sol-wde_ros_topbanner', member: 9742 },
			'ad-medium-rectangle': { invCode: 'sol-wde_ros_rectangle', member: 9742 },
			'ad-medium-rectangleB': { invCode: 'sol-wde_ros_rectangle', member: 9742 },
			'ad-medium-rectangle-perz': { invCode: 'sol-wde_ros_rectangle', member: 9742 },
			'ad-netboard': { invCode: 'sol-wde_ros_netboard', member: 9742 },
			'ad-netboardB': { invCode: 'sol-wde_ros_netboard', member: 9742 },
			'ad-netboard-perz': { invCode: 'sol-wde_ros_netboard', member: 9742 },
			'ad-sticky-right-top': { invCode: 'sol-wde_ros_skyscraper', member: 9742 },
			'ad-sticky-right': { invCode: 'sol-wde_ros_skyscraper', member: 9742 },
			'ad-smartbanner': { invCode: 'sol-wde_ros_smartbanner', member: 9742 },
			'ad-smartbanner-perz': { invCode: 'sol-wde_ros_smartbanner', member: 9742 },
			'ad-banner': { invCode: 'sol-wph_ros_rectangle', member: 9742 },
			'ad-banner-perz': { invCode: 'sol-wph_ros_rectangle', member: 9742 },
		},
	},
}

export function getPrebidConfigForSlot(site, slot) {
	const cfg = config[site] || config.default
	const providers = Object.keys(cfg)

	const bids = []

	providers.forEach(provider => {
		if (cfg[provider] && cfg[provider][slot]) {
			bids.push({
				bidder: provider,
				params: cfg[provider][slot],
			})
		}
	})

	return {
		enabled: true,
		mediaTypes: dimensions[slot] || dimensions.default,
		bids,
	}
}
