import React, { memo } from 'react'
import PropTypes from 'prop-types'
import { WallpaperAd } from '@aller/shiny/src/molecules/WallpaperAd'
import { Grid } from '@aller/shiny/src/atoms/Grid'
import { Row } from '@aller/shiny/src/atoms/Row'
import styled from 'styled-components'

import { useIsMetarefresh } from '../../hooks/useIsMetarefresh'
import AdSlot from './AdSlot'
import { getPrebidConfigForSlot, getSlotNameForPath, getSite, getPath } from './config'

// We need padding 0 only for topbanner, create custom Grid component
// And also offset the sticky header? :X
const StyledGrid = styled(Grid)`
	padding: 0;
`

const slot = 'ad-topbanner'
const site = getSite()
const path = getPath()
const prebid = getPrebidConfigForSlot(site, slot)

const TopBanner = ({ pos }) => {
	const isMetaRefresh = useIsMetarefresh()
	const slotName = getSlotNameForPath(site, path, isMetaRefresh)
	const adOptions = {
		slotName,
		dimensions: [
			[[1000, 300], [1010, 300], [980, 300], [970, 250], 'fluid'],
			[[980, 300], [970, 250], 'fluid'],
		],
		sizemap: {
			breakpoints: [[1345, 600], [970, 250]],
			refresh: true,
		},
		display: 'all',
		targeting: {
			platform: 'wolverine-logan',
			pos: `topbanner${pos}`,
		},
		bidding: {
			prebid,
		},
	}

	return (
		<StyledGrid>
			<Row>
				<WallpaperAd height="300px" width="980px" shouldHideAttribution={false}>
					<AdSlot id={`${slot}${pos}`} rootMargin="400px" {...adOptions} />
				</WallpaperAd>
			</Row>
		</StyledGrid>
	)
}

TopBanner.propTypes = {
	pos: PropTypes.number,
}

TopBanner.defaultProps = {
	pos: 1,
}

TopBanner.whyDidYouRender = true
TopBanner.slot = slot

export default memo(TopBanner)
