import React from 'react'
import PropTypes from 'prop-types'
import { AdWrapper } from '@aller/shiny/src/atoms/AdWrapper'
import Col from '@aller/shared/components/Col' // eslint-disable-line import/no-extraneous-dependencies
import SolPlug from '@aller/shared/components/SolPlug/Plug/SolPlug' // eslint-disable-line import/no-extraneous-dependencies, import/no-unresolved
import { useArticles } from '@aller/shared/store/ArticleStore' // eslint-disable-line import/no-extraneous-dependencies, import/no-unresolved
import { useIsMobile } from '@aller/shared/hooks/useIsMobile' // eslint-disable-line import/no-extraneous-dependencies, import/no-unresolved
import GridRow from '@aller/shared/components/GridRow'
import { useIsMetarefresh } from '../../hooks/useIsMetarefresh'
import MostRead from '../MostRead/Logan'

import { getPrebidConfigForSlot, getSlotNameForPath, getSite, getPath } from './config'

import AdSlot from './AdSlot'

const slot = 'ad-netboard'
const site = getSite()
const path = getPath()
const prebid = getPrebidConfigForSlot(site, slot)

const columnSizes = {
	xs: 12,
	md: 12,
}

const columnStyle = {
	fleexDirection: 'column',
	padding: 0,
	display: 'flex',
}

function calculateRatioByTitle(title) {
	const { length } = title

	switch (true) {
		case length <= 21:
			return 1.2
		case length < 42:
			return 1.1
		case length < 63:
			return 1
		default:
			return 0.9
	}
}

const XavierArticles = () => {
	const articles = useArticles(1)

	if (articles.length === 1) {
		const imageRatio = calculateRatioByTitle(articles[0].title)
		return (
			<Col style={columnStyle} md={4}>
				<div style={{ marginTop: '2.5rem', marginBottom: '1rem', display: 'flex', flex: 1 }}>
					<SolPlug
						{...articles[0]}
						fontSizeOverride={2.6}
						imageRatio={imageRatio}
						column={columnSizes}
						linkpulsePersonalizedClass
					/>
				</div>
			</Col>
		)
	}
	return null
}

const netboardStyles = {
	display: 'flex',
}

const NetboardWithXavier = ({ pos, articlesOnTheLeft }) => {
	const isMobile = useIsMobile()
	const isMetaRefresh = useIsMetarefresh()
	if (isMobile) return null
	const slotName = getSlotNameForPath(site, path, isMetaRefresh)
	const adOptions = {
		slotName,
		dimensions: [[580, 500], [580, 400], 'fluid'],
		display: 'all',
		targeting: {
			platform: 'wolverine-logan',
			pos: `netboard${pos}`,
		},
		bidding: {
			prebid,
		},
	}

	return (
		<GridRow style={netboardStyles}>
			{articlesOnTheLeft ? <XavierArticles /> : null}
			<AdWrapper height="400px" width="580px">
				<AdSlot id={`${slot}${pos}`} rootMargin="400px" {...adOptions} />
			</AdWrapper>
			{!articlesOnTheLeft && pos !== 1 ? <XavierArticles /> : null}
			{!articlesOnTheLeft && pos === 1 ? <MostRead /> : null}
		</GridRow>
	)
}

NetboardWithXavier.propTypes = {
	pos: PropTypes.number,
	articlesOnTheLeft: PropTypes.bool,
}

NetboardWithXavier.defaultProps = {
	pos: 1,
	articlesOnTheLeft: false,
}

NetboardWithXavier.slot = slot

NetboardWithXavier.whyDidYouRender = true

export default NetboardWithXavier
