import React, { useCallback } from 'react'
import styled, { withTheme } from 'styled-components'
import PropTypes from 'prop-types'
import { LogiclessModal } from '@aller/shiny/src/atoms/LogiclessModal'
import { getVariable } from '@aller/shiny/src/utils/get-variable'
import { LargeHeading } from '@aller/shiny/src/atoms/Heading'
import { Button } from '@aller/shiny/src/atoms/Button'
import { useAdsDispatch, useAdsStore } from './Provider'

const Title = ({ theme: { name } }) => (
	<>
		{name} er en del av <b>Aller Media</b>
	</>
)

Title.propTypes = {
	theme: PropTypes.shape({
		name: PropTypes.string,
	}).isRequired,
}

const Section = styled.section`
	font-family: ${getVariable('uiFont')};
`
const ThemedTitle = withTheme(Title)

const Modal = () => {
	const { showModal } = useAdsStore()
	const dispatch = useAdsDispatch()
	const handleClose = useCallback(() => dispatch({ type: 'HIDE_MODAL' }), [dispatch])
	return (
		<LogiclessModal isOpen={showModal} title={<ThemedTitle />} closeModal={handleClose}>
			<Section>
				<LargeHeading>Hvorfor ser du denne annonsen</LargeHeading>
				<p>
					Nettstedet du nå besøker blir i stor del finansiert av annonseinntekter. Basert på din
					tidligere aktivitet hos oss, vil du få annonser vi tror kan interessere deg.
				</p>
				<p>Du velger selv om du ønsker å endre dine innstillinger</p>
				<Button outline background="buttonColor">
					<a
						href="https://personvern.aller.no/annonseinnstillinger.html"
						rel="noopener noreferrer"
						target="_blank"
					>
						Les mer om innstillinger
					</a>
				</Button>
				<LargeHeading>Om Aller Media og annonsering</LargeHeading>
				<p>
					Aller Media eier nettstedene Dagbladet, Sol, DinSide, KK, Se og Hør, Lommelegen, Topp og
					Vi
				</p>
				<Button outline background="buttonColor">
					<a
						href="https://personvern.aller.no/relevantinnhold.html"
						rel="noopener noreferrer"
						target="_blank"
					>
						Les mer om Aller Media og annonser
					</a>
				</Button>
			</Section>
		</LogiclessModal>
	)
}

export default Modal
