import React from 'react'
import PropTypes from 'prop-types'
import { AdWrapper } from '@aller/shiny/src/atoms/AdWrapper'

import { useIsMetarefresh } from '../../hooks/useIsMetarefresh'
import { getPrebidConfigForSlot, getSlotNameForPath, getSite, getPath } from './config'
import AdSlot from './AdSlot'

const site = getSite()
const path = getPath()

const MediumRectangle = ({ pos, slot }) => {
	const isMetaRefresh = useIsMetarefresh()
	const slotName = getSlotNameForPath(site, path, isMetaRefresh)
	const prebid = getPrebidConfigForSlot(site, slot)

	const adOptions = {
		slotName,
		dimensions: [[300, 250], [320, 250], 'fluid'],
		display: 'all',
		targeting: {
			platform: 'wolverine-logan',
			pos: `${slot.slice(3)}${pos}`,
		},
		bidding: {
			prebid,
		},
	}

	return (
		<AdWrapper height="250px" width="320px">
			<AdSlot id={`${slot}${pos}`} rootMargin="400px" {...adOptions} />
		</AdWrapper>
	)
}

MediumRectangle.propTypes = {
	pos: PropTypes.number,
	slot: PropTypes.oneOf(['ad-medium-rectangle', 'ad-medium-rectangle-perz']),
}

MediumRectangle.defaultProps = {
	pos: 1,
	slot: 'ad-medium-rectangle',
}

MediumRectangle.whyDidYouRender = true

export default MediumRectangle
