import React from 'react'
import PropTypes from 'prop-types'
import { AdWrapper } from '@aller/shiny/src/atoms/AdWrapper'

import { useIsMetarefresh } from '../../hooks/useIsMetarefresh'
import AdSlot from './AdSlot'
import GridRow from '../GridRow'
import { getPrebidConfigForSlot, getSlotNameForPath, getSite, getPath } from './config'

const site = getSite()
const path = getPath()

const Banner = ({ pos, slot = 'ad-banner' }) => {
	const isMetaRefresh = useIsMetarefresh()
	const slotName = getSlotNameForPath(site, path, isMetaRefresh)
	const prebid = getPrebidConfigForSlot(site, slot)

	const adOptions = {
		slotName,
		dimensions: [[320, 250], [300, 250], [320, 400], 'fluid'],
		display: 'mobile',
		targeting: {
			platform: 'wolverine-logan',
			pos: `${slot.slice(3)}${pos}`,
		},
		bidding: {
			prebid,
		},
	}

	return (
		<GridRow>
			<AdWrapper height="250px" width="320px">
				<AdSlot id={`${slot}${pos}`} rootMargin="400px" {...adOptions} />
			</AdWrapper>
		</GridRow>
	)
}

Banner.propTypes = {
	pos: PropTypes.number,
	slot: PropTypes.oneOf(['ad-banner', 'ad-banner-perz']),
}

Banner.defaultProps = {
	pos: 1,
	slot: 'ad-banner',
}

Banner.whyDidYouRender = true

export default Banner
