/* eslint-disable import/prefer-default-export */
import React from 'react'
import styled from 'styled-components'
import { getColor } from '@aller/shiny/src/utils/get-color'
import { getVariable } from '@aller/shiny/src/utils/get-variable'
import Gear from '@aller/shiny/src/atoms/SvgIcon/dorris/Gear'

const StyledCog = styled.div`
	position: absolute;
	left: 0;
	top: ${getVariable('verticalBase')};
	padding: calc(${getVariable('horizontalBase')} / 2);
	background-color: ${getColor('background')};
	border-bottom-right-radius: 50%;
	opacity: 0.5;
	filter: alpha(opacity=50);
	line-height: 0;
	cursor: pointer;
`

const AdSettingsCog = props => (
	<StyledCog {...props}>
		<Gear width="16px" height="16px" fill="black" />
	</StyledCog>
)

export { AdSettingsCog }
