import styled from '@emotion/styled'

const ElectionNewsHeader = styled.h2`
	color: #453d3f;
	font-size: 2.2rem;
	font-weight: 800;
	margin: 1rem;
	text-align: center;
	padding-right: 2rem;
	padding-top: 5px;

	&:before {
		content: '';
		border-radius: 50rem;
		background: #e20513;
		height: 17px;
		width: 17px;
		display: inline-block;
		margin-right: 14px;
	}

	@media screen and (max-width: 550px) {
		font-size: 2rem;

		&:before {
			content: '';
			border-radius: 50rem;
			background: #e20513;
			height: 14px;
			width: 14px;
			display: inline-block;
			margin-right: 10px;
		}
	}
`

export default ElectionNewsHeader
