import React, { useState } from 'react'
import unfetch from 'isomorphic-unfetch'

import ElectionNewsTopRow from './styles/ElectionNewsTopRow'
import ElectionNewsSelect from './styles/ElectionNewsSelect'
import Wrapper from './styles/Wrapper'
import ElectionNewsList from './styles/ElectionNewsList'
import ElectionNewsListItem from './styles/ElectionNewsListItem'
import ElectionNewsHeader from './styles/ElectionNewsHeader'

function formatTime(dateTime) {
	const d = new Date(dateTime)
	const h = (d.getHours() < 10 ? '0' : '') + d.getHours()
	const m = (d.getMinutes() < 10 ? '0' : '') + d.getMinutes()
	return `${h}:${m}`
}

const LocalElectioNews = () => {
	const [articles, setArticles] = useState([])
	const [category, setCategory] = useState('')

	async function getArticles(municipality: string) {
		if (municipality === 'default') return
		const freeText = `valg 2019 OR val 2019 OR kommunevalg OR fylkestingvalg OR valgkamp OR valkamp OR valgresultat OR valresultat OR valgnatt OR valnatt OR forhåndsstemme OR valvake OR valgvake OR mandat`
		const filter = 'title,url,host,posted,paywall'
		const query = `includeAnyTags=${municipality}&tagFields=article_tags2&q=${freeText}&excludeTags=sport,underholdning,utenriks&excludeDupes=95&limit=6`
		const url = `https://sol.no/app/harvester-webservice/get?${query}&responseFilter=${filter}`

		const res = await unfetch(url).catch(() => null)

		if (res) {
			const data = await res.json()
			setArticles(data.items)
		}
	}

	return (
		<Wrapper>
			<ElectionNewsTopRow>
				<ElectionNewsHeader>Siste nyheter om valget fra:</ElectionNewsHeader>
				<ElectionNewsSelect
					onChange={(e: any) => {
						setCategory(e.target.value)
						getArticles(e.target.value)
					}}
					value={category}
				>
					<option value="default">Velg fylke</option>
					<option value="akershus">Akershus</option>
					<option value="aust agder">Aust-Agder</option>
					<option value="buskerud">Buskerud</option>
					<option value="finnmark">Finnmark</option>
					<option value="hedmark">Hedmark</option>
					<option value="hordaland">Hordaland</option>
					<option value="møre og romsdal">Møre og Romsdal</option>
					<option value="nordland">Nordland</option>
					<option value="oppland">Oppland</option>
					<option value="oslo">Oslo</option>
					<option value="rogaland">Rogaland</option>
					<option value="sogn og fjordane">Sogn og Fjordane</option>
					<option value="telemark">Telemark</option>
					<option value="troms">Troms</option>
					<option value="sør trøndelag,nord trøndelag">Trøndelag</option>
					<option value="vest agder">Vest-Agder</option>
					<option value="vestfold">Vestfold</option>
					<option value="østfold">Østfold</option>
				</ElectionNewsSelect>
			</ElectionNewsTopRow>
			<ElectionNewsList>
				{articles.map((article: any, i: number) => {
					return (
						<ElectionNewsListItem
							key={`${article.title}_${i}`}
							href={article.url}
							target="_blank"
							className={`lp_election_${category.replace(' ', '_')}_${i}`}
						>
							<div style={{ fontSize: '14px', color: '#333', marginRight: '10px' }}>
								{formatTime(article.posted)}
							</div>
							<div>
								<span style={{ fontWeight: 'bold', fontSize: '15px' }}>
									{article.paywall ? '(+) ' : null}
								</span>
								<p>{article.title.replace('(+) ', '').replace('(pluss)', '')}</p>
								<span>{article.host}</span>
							</div>
						</ElectionNewsListItem>
					)
				})}
			</ElectionNewsList>
		</Wrapper>
	)
}

export default LocalElectioNews
