import styled from 'styled-components'

import { getColor, getVariable } from '@aller/shiny/src/utils'

export const StyledUsefulLinks = styled.div`
	flex-grow: 1;
	flex-shrink: 0;
	flex-basis: calc(80% - ${getVariable('horizontalBase')});

	display: flex;
	flex-wrap: wrap;

	margin: 0 calc(1 / 2 * ${getVariable('horizontalBase')}) ${getVariable('verticalBase')};
	border: 0.1rem solid ${getColor('grayTint')};
	padding: calc(${getVariable('horizontalBase')} * 2);

	h3 {
		flex: 1 0 100%;
	}

	.box {
		flex: 1 0 40%;
		margin-right: calc(${getVariable('horizontalBase')} * 2);

		&:last-child {
			margin-right: 0;
		}

		select {
			width: 50%;
			margin-bottom: ${getVariable('verticalBase')};
		}

		.kvasir-search-field {
			height: 3.6rem;
			width: 100%;
			border: 0.1rem solid ${getColor('grayTint')};
			margin-left: 0;
		}

		.pb-google {
			padding-right: calc(${getVariable('verticalBase')} / 2);
			padding-top: 0.4rem;
			float: right;
			height: 1.9rem;
			width: 11rem;
		}
		.kvasir-logo {
			height: 1.2rem;
			width: 7.1rem;
		}
	}
`

export const StyledDropdowns = styled.div`
	display: flex;

	select {
		padding: 0.5rem;
		width: 20%;
		margin-right: ${getVariable('horizontalBase')};
		font-weight: 600;
	}
`

export const StyledLinks = styled.div`
	display: flex;
	flex-direction: row;

	.link-column {
		display: flex;
		flex-direction: row;
		flex-wrap: wrap;
		flex: 1 0 50%;

		a {
			width: 100%;
			border: 0;
			margin-bottom: 0.4rem;
		}
	}
`
