import React from 'react'

import { StyledUsefulLinks, StyledDropdowns, StyledLinks } from '../styles/UsefulLinksStyles'

import Dropdown from './Dropdown'
// import KvasirSearchField from '../../../shared-components/SiteHeader/components/KvasirSearchField'
const KvasirSearchField = ''
const UsefulLinks = props => {
	return (
		<StyledUsefulLinks>
			<h4>Nyttig</h4>
			<div className="box">
				{renderDropdowns()}
				<img
					className="kvasir-logo"
					alt="Kvasir"
					src="https://sol.no/s/img/h_12,w_71/static/kvasir.jpg"
				/>
				<KvasirSearchField />
				<img
					className="pb-google"
					alt="Powered by Google"
					src="https://sol.no/s/img/h_19,w_110/static/powered_by_google.png"
				/>
			</div>
			<div className="box">{renderLinks()}</div>
		</StyledUsefulLinks>
	)
}

function renderDropdowns() {
	return (
		<StyledDropdowns>
			<Dropdown defaultValue="default" onChange={followLink}>
				<option value="default">Banker</option>
				<option value="https://www.banknorwegian.no">Bank Norwegian</option>
				<option value="https://www.danskebank.no">Danske Bank</option>
				<option value="https://www.dnb.no">DNB</option>
				<option value="https://www.nordea.no">Nordea</option>
				<option value="https://sbanken.no">Sbanken</option>
				<option value="https://www.sparebank1.no">Sparebank1</option>
				<option value="https://www.sbm.no">Sparebanken Møre</option>
				<option value="https://www.ssf.no">Sparebanken Sogn og Fjordane</option>
				<option value="https://www.sor.no">Sparebanken Sør</option>
				<option value="https://www.spv.no">Sparebanken Vest</option>
				<option value="https://www.oest.no">Sparebanken Øst</option>
				<option value="https://www.storebrand.no/bank">Storebrand Bank</option>
			</Dropdown>
			<Dropdown defaultValue="default" onChange={followLink}>
				<option value="default">Kalkulatorer</option>
				<option value="https://www.dnb.no/bedrift/markets/valuta-renter/kalkulator/valutakalkulator.html">
					Valuta
				</option>
				<option value="https://www.finansportalen.no/bank/">Lån</option>
				<option value="https://www.finansportalen.no/forsikring">Forsikring</option>
				<option value="https://www.strompris.no/">Strøm</option>
				<option value="https://www.dinside.no/okonomi/skattekalkulator-2017/67512155">Skatt</option>
				<option value="https://www.nav.no/no/Person/Pensjon/Hva+kan+jeg+fa+i+pensjon">
					Pensjon
				</option>
				<option value="//www.hvakostertannlegen.no/">Hva koster tannlegen?</option>
			</Dropdown>
		</StyledDropdowns>
	)
}

function renderLinks() {
	return (
		<StyledLinks className="lp_fp_usfull_links">
			<div className="link-column">
				<a href="https://www.altinn.no/">Altinn</a>
				<a href="https://www.nav.no">Nav</a>
				<a href="https://www.1881.no/">1881</a>
				<a href="https://www.vegvesen.no/trafikkinformasjon/Reiseinformasjon/Trafikkmeldinger">
					Trafikkmeldinger
				</a>
				<a href="https://www.google.no/maps/">Google Maps</a>
				<a href="https://no.wikipedia.org/">Wikipedia</a>
			</div>
			<div className="link-column">
				<a href="https://test.no/">Test.no</a>
				<a href="https://www.forbrukerradet.no/">Forbrukerrådet</a>
				<a href="https://www.finn.no/">Finn.no</a>
				<a href="https://www.se.no/">TV-guide</a>
				<a href="https://www.norsk-tipping.no/">Norsk Tipping</a>
				<a href="https://sol.no/horoskop">Horoskop</a>
			</div>
		</StyledLinks>
	)
}

function followLink(e) {
	const url = e.target.value

	if (typeof url === 'string' && url !== 'default') {
		window.location = `${url}`
	}
}

export default UsefulLinks
