import PropTypes from 'prop-types'
import React from 'react'

import { StyledNewspapersList } from '../styles/NewspapersStyles'

class NewspapersList extends React.Component {
	renderCustomSources() {
		const { customSources } = this.props
		const sources = customSources

		if (Object.keys(sources).length === 0) {
			return null
		}

		return Object.keys(sources).map((item, i) => {
			const { name } = sources[item]
			const src = `https://sol.no/s/img/w_47,c_fill/sitelogos/${sources[item].domain}.gif`
			const url = `//${sources[item].domain}`

			return (
				<a key={i} href={url} title={name}>
					<img className="logo" alt={name} src={src} />
					<span className="source">{name}</span>
				</a>
			)
		})
	}

	render() {
		return (
			<StyledNewspapersList>
				<a href="https://www.tv2.no/" title="TV2">
					<img
						className="logo"
						alt="TV2"
						src="https://sol.no/s/img/w_80,c_fill/sitelogos/tv2-80.png"
					/>
					<span className="source">TV2</span>
				</a>
				<a href="https://www.dagbladet.no/" title="Dagbladet">
					<img
						className="logo"
						alt="Dagbladet"
						src="https://sol.no/s/img/w_80,c_fill/sitelogos/dagbladet-80.png"
					/>
					<span className="source">Dagbladet</span>
				</a>
				<a href="https://www.dn.no/" title="DN">
					<img
						className="logo"
						alt="DN"
						src="https://sol.no/s/img/w_80,c_fill/sitelogos/dn-80.png"
					/>
					<span className="source">DN</span>
				</a>
				<a href="https://www.nettavisen.no/" title="Nettavisen">
					<img
						className="logo"
						alt="Nettavisen"
						src="https://sol.no/s/img/w_80,c_fill/sitelogos/nettavisen-80.png"
					/>
					<span className="source">Nettavisen</span>
				</a>
				<a href="https://www.nrk.no/" title="NRK">
					<img
						className="logo"
						alt="NRK"
						src="https://sol.no/s/img/w_80,c_fill/sitelogos/nrk-80.png"
					/>
					<span className="source">NRK</span>
				</a>
				<a href="https://www.vg.no/" title="VG">
					<img
						className="logo"
						alt="VG"
						src="https://sol.no/s/img/w_80,c_fill/sitelogos/vg-80.png"
					/>
					<span className="source">VG</span>
				</a>
				<a href="https://www.aftenposten.no/" title="Aftenposten">
					<img
						className="logo"
						alt="Aftenposten"
						src="https://sol.no/s/img/w_80,c_fill/sitelogos/aftenposten-80.png"
					/>
					<span className="source">Aftenposten</span>
				</a>
				<a href="https://www.dinside.no/" title="Dinside">
					<img
						className="logo"
						alt="Dinside"
						src="https://sol.no/s/img/w_80,c_fill/sitelogos/dinside-80.png"
					/>
					<span className="source">Dinside</span>
				</a>
				<a href="https://www.kk.no/" title="KK">
					<img
						className="logo"
						alt="KK"
						src="https://sol.no/s/img/w_80,c_fill/sitelogos/kk-80.png"
					/>
					<span className="source">KK</span>
				</a>
				<a href="https://www.seher.no/" title="Se og hør">
					<img
						className="logo"
						alt="Se og hør"
						src="https://sol.no/s/img/w_80,c_fill/sitelogos/seher-80.png"
					/>
					<span className="source">Se og hør</span>
				</a>
				<a href="https://www.vi.no/" title="Vi">
					<img
						className="logo"
						alt="vi"
						src="https://sol.no/s/img/w_80,c_fill/sitelogos/vino.png"
					/>
					<span className="source">Vi</span>
				</a>
				<a href="https://www.lommelegen.no/" title="Lommelegen">
					<img
						className="logo"
						alt="Lommelegen"
						src="https://sol.no/s/img/w_80,c_fill/sitelogos/lommelegen.png"
					/>
					<span className="source">Lommelegen</span>
				</a>
				<a href="https://www.facebook.com/soldotno/" title="Facebook">
					<img
						className="logo"
						alt="Facebook"
						src="https://sol.no/s/img/w_80,c_fill/sitelogos/facebook-80.png"
					/>
					<span className="source">Facebook</span>
				</a>
				<a href="https://www.kode24.no/" title="Kode24">
					<img
						className="logo"
						alt="Kode24"
						src="https://sol.no/s/img/w_80,c_fill/sitelogos/kode24.png"
					/>
					<span className="source">Kode24</span>
				</a>

				<a href="https://www.elbil24.no/" title="elbil24">
					<img
						className="logo"
						alt="elbil24"
						src="https://sol.no/s/img/w_80,c_fill/sitelogos/elbil24.png"
					/>
					<span className="source">Elbil24</span>
				</a>
				{this.renderCustomSources()}
			</StyledNewspapersList>
		)
	}
}

NewspapersList.defaultProps = {
	customSources: []
}

NewspapersList.propTypes = {
	customSources: PropTypes.object // eslint-disable-line react/forbid-prop-types
}

export default NewspapersList
