import styled from 'styled-components'
import React from 'react'
import { getColor, getVariable } from '@aller/shiny/src/utils'
import { MediumHeading } from '@aller/shiny/src/atoms/Heading'
import { useIsMobile } from '@aller/shared/hooks/useIsMobile'
import XavierContentAd from '@aller/shared/components/LoganAds/XavierContentAd'
import Newspapers from './components/Newspapers'
import DoubleSideAds from '../doubleSideAds'
import MediumRectangle from '../LoganAds/MediumRectangle'

import hasStorage from '../../utils/has-storage'

const StyledSection = styled.section`
	display: flex;
	flex-grow: 1;
	flex-shrink: 1;
	flex-basis: 50%;
	flex-wrap: wrap;
	background: white;
	box-shadow: 0 1px 4px -1px rgba(20, 20, 60, 0.08);
	padding: 1.4rem;
	margin-bottom: ${getVariable('horizontalBase')};
	h1 {
		margin: 0 0 1rem 0;
	}
	.content-wrapper {
		display: flex;
		flex-wrap: wrap;
		flex: 0 0 100%;

		h4 {
			flex-grow: 1;
			flex-shrink: 0;
			flex-basis: calc(100% - ${getVariable('horizontalBase')});
			font-size: ${getVariable('headingSmallSize')};
			font-weight: ${getVariable('boldWeight')};
			line-height: ${getVariable('headingSmallLineHeight')};
			margin-bottom: calc(${getVariable('verticalBase')} / 2);
		}

		.newspapers,
		.weather {
			background: ${getColor('white')};
			flex-grow: 1;
			flex-shrink: 0;
			flex-basis: calc(40% - ${getVariable('horizontalBase')});
			margin: 0 calc(1 / 2 * ${getVariable('horizontalBase')}) 0;
		}
	}
`

const LinksEtCetera = props => {
	const canStore = hasStorage()

	if (useIsMobile()) {
		return (
			<StyledSection>
				<MediumHeading title="Snarveier"> Snarveier </MediumHeading>
				<div className="content-wrapper">
					<Newspapers className="newspapers" canStore={canStore} />
				</div>
			</StyledSection>
		)
	}

	return (
		<>
			<StyledSection>
				<MediumHeading title="Snarveier"> Snarveier </MediumHeading>
				<div className="content-wrapper">
					<Newspapers className="newspapers" canStore={canStore} />
				</div>
			</StyledSection>
			<DoubleSideAds>
				<XavierContentAd fontSizeOverride={2.2} column={{ md: 12 }} pos={props.contentPos} />
				<MediumRectangle pos={props.mediumRectanglePos} />
			</DoubleSideAds>
		</>
	)
}

export default LinksEtCetera
