import React from 'react'
import styled from 'styled-components'
import { useInView } from 'react-intersection-observer'
import Section from '../Section'

const StyledSection = styled(Section)`
	min-height: 20vh;
`

const LazyGridSection: React.FC = ({ children, ...rest }) => {
	const [ref, inView] = useInView({
		triggerOnce: true,
		rootMargin: '500px'
	})

	return (
		<StyledSection ref={ref} {...rest}>
			{inView && children}
		</StyledSection>
	)
}
;(LazyGridSection as any).whyDidYouRender = true

export default LazyGridSection
