import React from 'react'
import { useInView } from 'react-intersection-observer'
import GridSection from '../GridSection'

const LazyGridSection = ({ children, ...rest }) => {
	const [ref, inView] = useInView({
		triggerOnce: true,
		rootMargin: '500px'
	})
	return (
		<GridSection ref={ref} {...rest}>
			{inView && children}
		</GridSection>
	)
}
LazyGridSection.whyDidYouRender = true

export default LazyGridSection
