/* eslint-disable no-bitwise, no-nested-ternary */
import styled from 'styled-components'
import isInteger from 'lodash.isinteger'

import config from '../../utils/flex-grid-config'

interface Props {
	xs?: number | boolean
	xsOffset?: number
	sm?: number | boolean
	smOffset?: number
	md?: number | boolean
	mdOffset?: number
	lg?: number | boolean
	lgOffset?: number
	reverse?: boolean
}

const dimensions = ['xs', 'sm', 'md', 'lg']
const offsets = ['xsOffset', 'smOffset', 'mdOffset', 'lgOffset']

const Col = styled.div<Props>`
  box-sizing: border-box;
  flex: 0 0 auto;
  padding-right: ${p => config(p).gutterWidth / 2}rem;
  padding-left: ${p => config(p).gutterWidth / 2}rem;
  ${p =>
		p.reverse &&
		`
    flex-direction: column-reverse;
  `}
  ${(p: Props) =>
		Object.keys(p)
			.filter(k => dimensions.indexOf(k) > -1)
			.sort((k1, k2) => dimensions.indexOf(k1) - dimensions.indexOf(k2))
			.map(
				(k: string) =>
					config(p).media[k]`${
						isInteger((p as any)[k])
							? // Integer value
							  `
        flex-basis: ${(100 / config(p).gridSize) * (p as any)[k]}%;
        max-width: ${(100 / config(p).gridSize) * (p as any)[k]}%;
        display: block;
      `
							: // Boolean
							(p as any)[k]
							? // Auto-width
							  `
          flex-grow: 1;
          flex-basis: 0;
          max-width: 100%;
          display: block;
        `
							: // Hide element
							  'display: none;'
					}`
			)}
  ${p =>
		Object.keys(p)
			.filter(k => ~offsets.indexOf(k))
			.map(
				k => config(p).media[k.replace(/Offset$/, '')]`
        margin-left: ${(100 / config(p).gridSize) * (p as any)[k]}%;
      `
			)}
`

Col.displayName = 'Col'

export default Col
