import styled from 'styled-components'
import { Grid } from '@aller/shiny/src/atoms/Grid'
import { getColor } from '@aller/shiny/src/utils/get-color'

export const EavisLatestListContainer = styled(Grid)`
	color: ${getColor('darkness')};
	width: 100%;
	max-width: 100rem;
	align-items: center;
	display: flex;
	flex-wrap: wrap;
	margin: 0 auto;
`

export const EavisListContainerWrapper = styled.div`
	padding: 4rem 0 4rem;
	position: relative;
	background: linear-gradient(180deg, #efefef, transparent);
	@media screen and (max-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
		display: none;
	}
	&.x6-per-row {
		.eavis-issue-wrapper {
			flex: 0 0 16%;
			h1 {
				font-size: 1.2rem;
			}
		}
	}
`

export const EavisIssueWrapper = styled.div`
	flex: 0 0 20%;
	margin-bottom: 2rem;
	height: 26rem;
`

export const EavisIssueLink = styled.a`
	color: ${getColor('darkness')};
	display: flex;
	align-items: center;
	flex-direction: column;
	justify-content: center;
	cursor: pointer;
	text-decoration: none;
	height: 100%;
	justify-content: space-between;
	&:hover img {
		transform: translateX(-0.2rem) translateY(-0.2rem);
		box-shadow: 0 1rem 2.2rem rgba(0, 0, 0, 0.4);
	}
	&:hover h1 {
		text-decoration: underline;
	}
	h1 {
		margin: 0.5rem auto;
		&:first-letter {
			text-transform: uppercase;
		}
	}
	img {
		min-width: 80%;
		max-height: 22.1rem;
	}
`
