import styled from 'styled-components'
import { XLargeHeading, XSmallHeading, LargeHeading } from '@aller/shiny/src/atoms/Heading'
import { Grid } from '@aller/shiny/src/atoms/Grid'
import { getColor } from '@aller/shiny/src/utils/get-color'
import { getVariable } from '@aller/shiny/src/utils/get-variable'

export const EavisContainer = styled.div`
	padding: 5rem 0 0;
	position: relative;
	font-family: ${getVariable('mainFont')};
	&.searchPage {
		padding-top: 0;
	}
	@media screen and (max-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
		font-family: ${getVariable('mainFont')};
	}
`
export const Eavis = styled.div`
	padding: 5rem 0 2rem;
	position: relative;
	&.md-non-visible {
		@media screen and (max-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
			display: none;
		}
	}
`
export const EavisDato = styled.div`
	padding: 5rem 0 2rem;
	position: relative;
	background: linear-gradient(180deg, #fff 35rem, #efefef 35rem, #fff);
	&.md-non-visible {
		@media screen and (max-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
			display: none;
		}
	}
`

export const BlockHeading = styled(XLargeHeading)`
	text-align: center;
	margin-top: 0;
	@media screen and (min-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
		margin-left: auto;
		margin-right: auto;
		font-weight: ${getVariable('uiWeightBold')};
	}
`
export const IssueDate = styled(XSmallHeading)`
	@media screen and (min-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
		font-size: ${getVariable('headingSmallSize')};
	}
`

export const EavisTopIssueContainer = styled(Grid)`
	display: flex;
	padding: 6rem 1.5rem 4rem 1.5rem;
`
export const EavisCurrentIssueImage = styled.div`
	box-shadow: 0 1rem 2.2rem rgba(0, 0, 0, 0.4);
	position: relative;
`
export const EavisTopIssueCurrentIssue = styled.div`
	padding-right: 4rem;
	position: relative;
	z-index: 10;
	flex: 0 0 40rem;
	&:hover .eavis-controls {
		opacity: 1;
	}
`
export const EavisIssueImage = styled.img`
	width: 40rem;
	max-height: 100%;
`
export const EavisIssueControls = styled.div`
	position: absolute;
	left: 0;
	top: 0;
	width: 100%;
	height: 100%;
	background-color: rgba(0, 0, 0, 0.4);
	display: flex;
	justify-content: center;
	align-items: center;
	flex-direction: column;
	opacity: 0;
	transition: all 0.1s ease-in-out;
`
export const EavisIssueImageShowPreview = styled.button`
	display: block;
	max-width: 80%;
	border: 0.1rem solid rgba(255, 255, 255, 0.7);
	border-radius: 0.2rem;
	padding: 1rem 2rem;
	color: white;
	text-transform: uppercase;
	background-color: rgba(0, 0, 0, 0.6);
	text-decoration: none;
	margin-bottom: 1rem;
	font-size: ${getVariable('uiRegularSize')};
	font-weight: ${getVariable('uiWeight')};
	transition: all 0.1s ease-in-out;
	font-family: Helvetica;
	cursor: pointer;
	&:hover {
		transform: scale(1.1);
	}
`
export const EavisIssueShowDetails = styled.a`
	display: block;
	max-width: 80%;
	border: 0.1rem solid rgba(255, 255, 255, 0.7);
	border-radius: 0.2rem;
	padding: 1rem 2rem;
	color: white;
	text-transform: uppercase;
	background-color: rgba(0, 0, 0, 0.6);
	text-decoration: none;
	margin-bottom: 1rem;
	font-size: ${getVariable('uiRegularSize')};
	font-weight: ${getVariable('uiWeight')};
	transition: all 0.1s ease-in-out;
	font-family: Helvetica;
	&:hover {
		transform: scale(1.1);
	}
`
export const EavisXLargeHead = styled(XLargeHeading)`
	@media screen and (min-width: ${props => props.theme.flexboxgrid.breakpoints.sm}em) {
		margin: 0;
	}
`
export const EavisSmallHead = styled(XSmallHeading)`
	@media screen and (min-width: ${props => props.theme.flexboxgrid.breakpoints.sm}em) {
		margin: 0.2rem 0 0.5rem 0;
	}
`
export const EavisLargeHeading = styled(LargeHeading)`
	@media screen and (min-width: ${props => props.theme.flexboxgrid.breakpoints.sm}em) {
		margin: 0.2rem 0 0.5rem 0;
		&:first-letter {
			text-transform: uppercase;
		}
	}
`
export const EavisIssueDate = styled.div`
	padding-top: 2rem;
	text-align: center;
	font-family: ${getVariable('mainFont')};
`
export const EavisTopIssueSubscriptionInfo = styled.div`
	width: 100%;
	text-align: left;
`
export const EavisTopIssueLogin = styled.div`
	padding-top: 2rem;
`
export const LoginButton = styled.a`
	font-family: ${getVariable('mainFont')};
	padding: 1.2rem 1.6rem;
	font-size: ${getVariable('uiSmallSize')};
	border: 0.1rem solid ${getColor('grayTintLight')};
	background: transparent;
	color: ${getColor('link')};
	cursor: pointer;
	font-weight: ${getVariable('uiWeightBold')};
	text-transform: uppercase;
	max-width: 11rem;
	text-align: center;
	margin-bottom: 2rem;
	transition: all 0.1s ease-in-out;
	display: inline-block;
	&:hover {
		background-color: rgba(236, 236, 236, 0.9);
	}
`
export const GetSubscriptionButton = styled.a`
	font-family: ${getVariable('mainFont')};
	padding: 1.2rem 1.6rem;
	font-size: ${getVariable('uiSmallSize')};
	cursor: pointer;
	font-weight: ${getVariable('uiWeightBold')};
	text-transform: uppercase;
	background-color: rgba(214, 0, 0, 1);
	border-color: ${getColor('primaryDark')};
	color: ${getColor('white')};
	transition: all 0.1s ease-in-out;
	display: inline-block;
	&:hover {
		background-color: rgba(214, 0, 0, 0.7);
	}
`
export const EavisTopIssueDescription = styled.div`
	margin-top: 2rem;
	width: 100%;
	font-family: ${getVariable('mainFont')};
	p {
		font-family: inherit;
		font-weight: ${getVariable('uiWeight')};
		font-size: ${getVariable('uiRegularSize')};
		line-height: ${getVariable('uiRegularLineHeight')};
		margin-bottom: 1.25rem;
		text-rendering: optimizeLegibility;
	}
`
export const EavisBoldText = styled.div`
	font-weight: ${getVariable('uiWeightSemiBold')};
	font-family: ${getVariable('mainFont')};
	margin-bottom: 1rem;
`
export const EavisBoldTextDato = styled.strong`
	font-weight: ${getVariable('uiWeightSemiBold')};
	font-family: ${getVariable('mainFont')};
`
export const EavisCapitalize = styled.span`
	text-transform: capitalize;
`
export const EavisDatoPagesContainer = styled.div`
	display: flex;
	flex-wrap: wrap;
	max-width: 100rem;
	width: 100%;
	margin: 0 auto;
	position: relative;
	padding-top: 6rem;
`
export const EavisDatoPage = styled.div`
	flex: 0 0 25%;
	margin-bottom: 2rem;
	a:hover {
		color: ${getColor('darkness')};
		text-decoration: underline;
	}
	a:hover img {
		transform: translateX(-0.2rem) translateY(-0.2rem);
		box-shadow: 0 1rem 2.2rem rgba(0, 0, 0, 0.4);
	}
`
export const EavisDatoPageLink = styled.a`
	display: flex;
	align-items: center;
	flex-direction: column;
	justify-content: center;
`
export const EavisDatoPageImage = styled.img`
	transition: all 0.1s ease-in-out;
	margin-bottom: 1rem;
	height: 21.4rem;
`
export const GetSubscriptionButtonContainer = styled.div`
	box-sizing: border-box;
`

export const ErrorBlock = styled.div`
	font-family: ${getVariable('mainFont')};
	padding: 3rem 1.5rem;
	width: 100%;
	max-width: 100rem;
	margin: 0 auto;
	a,
	a:visited {
		color: ${getColor('darkness')};
		text-decoration: none;
		font-size: ${getVariable('uiLargeSize')};
	}
	a:hover {
		text-decoration: underline;
	}
`

export const MobileGrid = styled(Grid)`
	font-family: ${getVariable('mainFont')};
	padding-top: 5rem;
	display: flex;
	flex-wrap: wrap;

	.linksContainer {
		width: 100%;
		text-align: center;

		a {
			display: inline-block;
			margin: auto auto 1.5rem;
			text-decoration: none;

			&.openAppLink {
				background: ${getColor('primary')};
				color: ${getColor('white')};
				padding: 1rem 2rem;
				font-size: ${getVariable('uiRegularSize')};
				font-weight: ${getVariable('uiWeightBold')};
				text-transform: uppercase;
				border-radius: 0.3rem;
				border: 1px solid ${getColor('primaryDark')};
			}
		}
	}
`

export const EavisMobileSplashImg = styled.img`
	width: 100%;
	padding-left: 1.5rem;
	padding-right: 1.5rem;
`

export const EavisMobileFallback = styled.div`
	padding: 5rem 0 2rem;
	position: relative;
	display: none;
	@media screen and (max-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
		display: block;
	}
`

export const EavisPreviewOverlay = styled.div`
	position: fixed;
	width: 100%;
	height: 100%;
	background: rgba(0, 0, 0, 0.8);
	z-index: 800;
	top: 0;
	left: 0;
	display: none;
	justify-content: center;
	align-items: center;
	padding: 5rem 2rem 2rem;
	&.open {
		display: flex;
	}

	img {
		max-height: 100%;
	}
	button.closeEavisImagePreview {
		position: fixed;
		top: 5rem;
		right: 2rem;
		width: 4rem;
		height: 4rem;
		display: flex;
		align-items: center;
		justify-content: center;
		border: 1px solid rgba(255, 255, 255, 0.8);
		transform: rotate(45deg);
		color: ${getColor('white')};
		background-color: transparent;
		font-size: ${getVariable('uiLargeSize')};
		font-weight: ${getVariable('uiWeight')};
		margin: 0;
		padding: 0;
		border-radius: 50%;
		cursor: pointer;
	}
`
