import format from 'date-fns/format'
import nb from 'date-fns/locale/nb'

export function GetIssueLink(date, type) {
	const hrefDate = format(new Date(date), 'yyyy/MM/dd')
	const t = type === 'magasinet' ? '&t=magasinet' : ''
	return `/eavis/dato/?d=${hrefDate}${t}`
}

export function GetIssuePageLink(date, page, type) {
	const hrefDate = format(new Date(date), 'yyyy/MM/dd')
	const t = type === 'magasinet' ? '&t=magasinet' : ''
	page = page ? `&page=${page}` : '&page=0'
	return `/eavis/issue_click?date=${hrefDate}${page}${t}`
}

export function GetPaywallURL() {
	return 'https://www.dagbladet.no/pluss-om'
}

export function GetIssueListTitle(type, date, issueTitle) {
	if (type === 'magasinet') {
		const dt = format(new Date(date), 'd. MMMM', { locale: nb })
		return `Magasinet ${dt}`
	}

	// dagbladet or other case
	return format(new Date(date), 'EEEE d. MMMM', { locale: nb })
}
