import styled from 'styled-components'
import { Grid } from '@aller/shiny/src/atoms/Grid'

import { getColor } from '@aller/shiny/src/utils/get-color'
import { getVariable } from '@aller/shiny/src/utils/get-variable'

export const EavisCalendarContainer = styled(Grid)`
	width: 100%;
	padding: 0 6rem;
	align-items: center;
	display: flex;
	@media screen and (max-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
		display: none;
	}
`
export const Calendar = styled.div`
	max-width: 60rem;
	width: 100%;
	margin: 1rem auto 2rem;
	font-family: ${getVariable('mainFont')};
`
export const CalendarNaviBar = styled.div`
	height: 4.5rem;
	width: 100%;
	background: ${getColor('primary')};
`
export const CalendarMonthLink = styled.button`
	display: inline-block;
	text-transform: uppercase;
	color: ${getColor('white')};
	font-size: ${getVariable('uiRegularSize')};
	font-family: inherit;
	padding: 1rem 2rem;
	line-height: ${getVariable('uiLargeLineHeight')};
	transition: background-color 300ms ease-out;
	font-weight: ${getVariable('uiWeightBold')};
	cursor: pointer;
	background: transparent;
	border: none;
	&:focus {
		outline: none;
	}
	&:hover {
		background: ${getColor('primaryDark')};
	}
	&.disabled {
		cursor: default;
		color: #eda1a1;
	}
`
export const CalendarYearMonthTitle = styled.div`
	display: inline-block;
	color: ${getColor('white')};
	padding: 1rem 2rem;
	line-height: ${getVariable('uiLargeLineHeight')};
	text-transform: uppercase;
`

export const CalendarDaysBlock = styled.div`
	width: 100%;
	background: ${getColor('white')};
	display: grid;
	grid-template-columns: repeat(7, 1fr);
`

export const DayCell = styled.div`
	line-height: ${getVariable('headingSmallLineHeight')};
	padding: 0.8rem 0.7rem;
	border-right: 0.1rem solid ${getColor('grayTintLight')};
	border-bottom: 0.1rem solid ${getColor('grayTintLight')};
	&.wBar {
		font-weight: ${getVariable('uiWeightBold')};
	}
	&:nth-of-type(7n) {
		border-right: none;
	}
	&:nth-of-type(n + 1):nth-of-type(-n + 7),
	&:nth-of-type(n + 15):nth-of-type(-n + 21),
	&:nth-of-type(n + 29):nth-of-type(-n + 35),
	&:nth-of-type(n + 43):nth-of-type(-n + 49) {
		background: ${getColor('grayTintLighter')};
	}
`
export const CalendarDayLink = styled.a`
	text-decoration: none;
	color: ${getColor('darkness')};
	&:hover {
		text-decoration: underline;
	}
`
