import React from 'react'
import propTypes from 'prop-types'
import EavisSearchIssueListItem from './EavisSearchIssueListItem'
import { EavisSearchIssueListStyled } from './search'

const EavisSearchIssueList = ({ results }) => {
	if (!results.length) {
		return null
	}

	return (
		<EavisSearchIssueListStyled>
			{results.map((issue, key) => {
				return <EavisSearchIssueListItem key={key} issue={issue} />
			})}
		</EavisSearchIssueListStyled>
	)
}

EavisSearchIssueList.propTypes = {
	results: propTypes.arrayOf(propTypes.shape),
}

EavisSearchIssueList.defaultProps = {
	results: [],
}

export default EavisSearchIssueList
