import React, { useState } from 'react'
import { SearchInputContainer, EavisSearchForm, EavisSearchButton } from './search'

const EavisSearchFormText = () => {
	const [query, setQuery] = useState('')
	const [from, setDateFrom] = useState('')
	const [to, setDateTo] = useState('')

	const handleQuery = ({ target }) => setQuery(target.value)
	const handleDateFrom = ({ target }) => setDateFrom(target.value)
	const handleDateTo = ({ target }) => setDateTo(target.value)

	const submit = () => {
		const url = new URL(window.location.origin.concat(window.location.pathname))
		const queryString = url.search
		const searchParams = new URLSearchParams(queryString)

		searchParams.append('q', query)
		searchParams.append('from', from)
		searchParams.append('to', to)
		searchParams.append('page', 1)

		url.search = searchParams.toString()
		// Router.push(url.toString()) // @todo client side rendering
		window.location.href = url.toString() // for mvp we do it only serverside
	}

	return (
		<EavisSearchForm>
			<SearchInputContainer className="textInput">
				<label htmlFor="searchText">
					Søk på ord, tema, navn, etc…
					<input
						onChange={handleQuery}
						id="searchText"
						type="text"
						value={query}
						placeholder='F.eks landbruk eller "Einar Gerhardsen"'
					/>
				</label>
			</SearchInputContainer>
			<SearchInputContainer className="dateInput">
				<label htmlFor="fromDate">
					Fra dato
					<input
						onChange={handleDateFrom}
						id="fromDate"
						type="date"
						placeholder='F.eks landbruk eller "Einar Gerhardsen"'
					/>
				</label>
			</SearchInputContainer>
			<SearchInputContainer className="dateInput">
				<label htmlFor="toDate">
					Til dato
					<input
						onChange={handleDateTo}
						id="toDate"
						type="date"
						placeholder='F.eks landbruk eller "Einar Gerhardsen"'
					/>
				</label>
			</SearchInputContainer>
			<EavisSearchButton onClick={submit} type="button">
				SØK
			</EavisSearchButton>
		</EavisSearchForm>
	)
}

export default EavisSearchFormText
