import React, { useState } from 'react'
import { Grid } from '@aller/shiny/src/atoms/Grid'
import { Row } from '@aller/shiny/src/atoms/Row'
import {
	EavisSearchFormContainer,
	SearchToggle,
	SearchSlider,
	SliderFormCell,
	SliderCellContainer,
	EavisSearchNaviButton,
} from './search'
import EavisSearchFormText from './EavisSearchFormText'
import EavisSearchFormIssue from './EavisSearchFormIssue'

const EavisSearchFormSlider = () => {
	const [toggle, setToggle] = useState('')
	return (
		<Grid>
			<Row>
				<SearchToggle>
					<span>Søkevalg</span>
					<EavisSearchNaviButton
						className={toggle === '' ? 'active' : ''}
						onClick={() => {
							setToggle('')
						}}
						type="button"
					>
						FRITEKST
					</EavisSearchNaviButton>
					<EavisSearchNaviButton
						className={toggle === 'velgAvis' ? 'active' : ''}
						onClick={() => {
							setToggle('velgAvis')
						}}
						type="button"
					>
						VELG AVIS
					</EavisSearchNaviButton>
				</SearchToggle>
			</Row>
			<Row>
				<SearchSlider>
					<SliderCellContainer className={toggle}>
						<SliderFormCell>
							<EavisSearchFormText />
						</SliderFormCell>
						<SliderFormCell>
							<EavisSearchFormIssue />
						</SliderFormCell>
					</SliderCellContainer>
				</SearchSlider>
			</Row>
		</Grid>
	)
}

export default EavisSearchFormSlider
