import React from 'react'
import { Grid } from '@aller/shiny/src/atoms/Grid'
import {
	SearchDescritpion,
	SearchDescritpionCol,
	SearchButAbonnementLink,
	XMediumHeading,
} from './search'
import { GetPaywallURL } from './functions'

const EavisSearchDescritpion = () => {
	return (
		<SearchDescritpion>
			<Grid>
				<SearchDescritpionCol>
					<XMediumHeading>Hva er Dagbladets arkivsøk?</XMediumHeading>
					<p>
						Med Dagbladets arkivsøk finner du det du leter etter, enten det er avisen fra dagen du
						ble født, eller hva en politiker sa for 10 år siden. Du kan søke etter f.eks ord, navn,
						sitat, eller annet, og begrense på dato om du ønsker det. Det er også mulig å gå direkte
						til én utgave om du ikke vil søke etter noe spesielt.
					</p>
					<p className="italic">
						Arkivsøk er en tjeneste under utvikling, hvor utgaver blir lagt til så fort de er klare.
						For øyeblikket mangler vi noen utgaver, men forventer å få det meste på plass
						fortløpende.
					</p>
				</SearchDescritpionCol>
				<SearchDescritpionCol>
					<p>
						Det er <b>gratis</b> å søke, men for å lese avisene trenger man Dagbladet
						Pluss-abonnement.
					</p>
					<SearchButAbonnementLink href={GetPaywallURL()}>Kjøp abonnement</SearchButAbonnementLink>
				</SearchDescritpionCol>
			</Grid>
		</SearchDescritpion>
	)
}
export default EavisSearchDescritpion
